<?php

namespace App\Http\Controllers;

use App\Models\AccountType;
use Illuminate\Http\Request;


class AccountTypeController extends Controller
{
    public function index()
    {
        $types = AccountType::all();
        return view('admin.account_types.index', compact('types'));
    }

    public function create()
    {
        return view('admin.account_types.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:account_types,name',
            'min_balance' => 'required|numeric',
            'interest_rate' => 'required|numeric',
            'has_interest' => 'required|boolean',
        ]);

        AccountType::create($request->all());

        return redirect()->route('admin.account_types.index')
            ->with('success', 'Account type created successfully');
    }


    public function edit(AccountType $type)
{
    return view('admin.account_types.edit', compact('type'));
}

public function update(Request $request, AccountType $type)
{
    $request->validate([
        'name' => 'required|unique:account_types,name,' . $type->id,
        'min_balance' => 'required|numeric',
        'interest_rate' => 'required|numeric',
        'has_interest' => 'required|boolean',
    ]);

    $type->update($request->all());

    return redirect()->route('admin.account_types.index')
        ->with('success', 'Account type updated successfully.');
}

public function destroy(AccountType $type)
{
    $type->delete();

    return redirect()->route('admin.account_types.index')
        ->with('success', 'Account type deleted.');
}

// Activate / Deactivate
public function toggleStatus(AccountType $type)
{
    $type->status = $type->status === 'active' ? 'inactive' : 'active';
    $type->save();

    return redirect()->route('admin.account_types.index')
        ->with('success', 'Status updated successfully.');
}

}
