<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthenticatedSessionController extends Controller
{
    public function create(): View
    {
        return view('auth.login');
    }

    public function store(LoginRequest $request): RedirectResponse
{
    $request->authenticate();

    $request->session()->regenerate();

    $user = Auth::user();

    // If a previously intended URL exists, use it
    if (session()->has('url.intended')) {
        return redirect()->intended();
    }

    // ROLE-BASED REDIRECTS
    switch ($user->role) {

        case 'admin':
            return redirect()->route('admin.dashboard');

        case 'loan_officer':
            return redirect()->route('loan_officer.loans.index');

        case 'accountant':
            // You can update this later when accountant dashboard is ready
            return redirect('/accountant');

        case 'member':
        default:
            return redirect()->route('member.dashboard');
    }
}


    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
