<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class GroupLoan extends Model
{
use HasFactory;


protected $fillable = [
'group_id',
'principal',
'interest_rate',
'loan_period_months',
'balance',
'status',
'disbursed_at',
];


public function group()
{
return $this->belongsTo(Group::class);
}


public function repayments()
{
return $this->hasMany(GroupLoanRepayment::class, 'group_loan_id');
}


public function members()
{
return $this->group->members();
}
}