<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Income extends Model
{
    protected $fillable = [
        'receipt_no',
        'income_type_id',
        'member_id',
        'account_id',
        'payment_method',
        'amount',
        'income_date',
        'description',
        'recorded_by',
    ];

    public function type()
    {
        return $this->belongsTo(IncomeType::class, 'income_type_id');
    }

    public function member()
    {
        return $this->belongsTo(User::class, 'member_id');
    }

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'recorded_by');
    }
}
