<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndividualLoanRepayment extends Model
{
    protected $fillable = [
        'loan_id',
        'member_id',
        'admin_id',
        'amount',
        'balance_before',
        'balance_after',
        'status',
        'notes',
        'reference'
    ];

    public function loan()
    {
        return $this->belongsTo(Loan::class);
    }

    public function member()
    {
        return $this->belongsTo(User::class, 'member_id');
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
}
