<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class LoanType extends Model
{
    protected $fillable = [
        'name','slug','description','interest_rate','duration_months',
        'min_amount','max_amount','rules',
        'allow_member_application','allow_admin_application','is_group_loan','status'
    ];

    protected $casts = [
        'rules' => 'array',
        'allow_member_application' => 'boolean',
        'allow_admin_application' => 'boolean',
        'is_group_loan' => 'boolean',
    ];

    protected static function booted()
    {
        static::creating(function ($lt) {
            if (empty($lt->slug)) {
                $lt->slug = Str::slug($lt->name) . '-' . substr(md5(time()), 0, 6);
            }
        });
    }

    public function loans()
    {
        return $this->hasMany(Loan::class);
    }

    // convenience
    public function isGroupLoan(): bool
    {
        return (bool) $this->is_group_loan;
    }
}
