<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('loan_repayments', function (Blueprint $table) {
            if (!Schema::hasColumn('loan_repayments', 'due_date')) {
                $table->date('due_date')->nullable();
            }

            if (!Schema::hasColumn('loan_repayments', 'status')) {
                $table->enum('status', ['pending', 'paid', 'overdue'])->default('pending');
            }
        });
    }

    public function down()
    {
        Schema::table('loan_repayments', function (Blueprint $table) {
            if (Schema::hasColumn('loan_repayments', 'due_date')) {
                $table->dropColumn('due_date');
            }

            if (Schema::hasColumn('loan_repayments', 'status')) {
                $table->dropColumn('status');
            }
        });
    }
};
