<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up()
{
    Schema::create('individual_loan_repayments', function (Blueprint $table) {
        $table->id();

        $table->foreignId('loan_id')->constrained()->cascadeOnDelete();
        $table->foreignId('member_id')->constrained('users')->cascadeOnDelete();
        $table->foreignId('admin_id')->nullable()->constrained('users');

        $table->decimal('amount', 12, 2);
        $table->decimal('balance_before', 12, 2)->nullable();
        $table->decimal('balance_after', 12, 2)->nullable();

        $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');

        $table->string('reference')->nullable();
        $table->text('notes')->nullable();

        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('individual_loan_repayments');
    }
};
