@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-6 py-6">

    <h1 class="text-2xl font-bold text-white text-center mb-6">
        Edit Account Type
    </h1>

    <div class="max-w-2xl mx-auto bg-gray-800 p-8 rounded-lg shadow">

        <form action="{{ route('admin.account_types.update', $type->id) }}" method="POST">
            @csrf
            @method('PUT')

            <!-- Name -->
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Name</label>
                <input type="text"
                       name="name"
                       value="{{ old('name', $type->name) }}"
                       class="w-full p-2 bg-gray-700 text-white rounded"
                       required>
            </div>

            <!-- Minimum Balance -->
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Minimum Balance</label>
                <input type="number"
                       step="0.01"
                       name="min_balance"
                       value="{{ old('min_balance', $type->min_balance) }}"
                       class="w-full p-2 bg-gray-700 text-white rounded"
                       required>
            </div>

            <!-- Interest Rate -->
            <div class="mb-4">
                <label class="block text-gray-300 mb-2">Interest Rate (%)</label>
                <input type="number"
                       step="0.1"
                       name="interest_rate"
                       value="{{ old('interest_rate', $type->interest_rate) }}"
                       class="w-full p-2 bg-gray-700 text-white rounded"
                       required>
            </div>

            <!-- Has Interest -->
            <div class="mb-6">
                <label class="block text-gray-300 mb-2">Has Interest?</label>
                <select name="has_interest"
                        class="w-full p-2 bg-gray-700 text-white rounded">
                    <option value="1" {{ $type->has_interest ? 'selected' : '' }}>Yes</option>
                    <option value="0" {{ !$type->has_interest ? 'selected' : '' }}>No</option>
                </select>
            </div>

            <!-- Buttons -->
            <div class="flex items-center gap-4">
                <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
                    Update Type
                </button>

                <a href="{{ route('admin.account_types.index') }}"
                   class="text-gray-400 hover:text-gray-200">
                    Cancel
                </a>
            </div>

        </form>

    </div>

</div>
@endsection
