@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-6 py-6">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-white">Account Types</h1>

        <a href="{{ route('admin.account_types.create') }}"
           class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded shadow">
            + Add Account Type
        </a>
    </div>

    <div class="bg-gray-800 text-gray-200 rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-700 text-gray-300 uppercase text-sm">
                <tr>
                    <th class="px-4 py-3 text-left">Name</th>
                    <th class="px-4 py-3 text-left">Min Balance</th>
                    <th class="px-4 py-3 text-left">Interest Rate (%)</th>
                    <th class="px-4 py-3 text-left">Has Interest?</th>
                    <th class="px-4 py-3 text-left">Status</th>
                    <th class="px-4 py-3 text-left">Actions</th>
                </tr>
            </thead>

            <tbody>
                @foreach($types as $type)
                <tr class="border-b border-gray-700">
                    <td class="px-4 py-3">{{ $type->name }}</td>
                    <td class="px-4 py-3">{{ number_format($type->min_balance) }}</td>
                    <td class="px-4 py-3">{{ $type->interest_rate }}%</td>
                    <td class="px-4 py-3">{{ $type->has_interest ? 'Yes' : 'No' }}</td>

                    <td class="px-4 py-3">
                        @if($type->status === 'active')
                            <span class="text-green-400 font-semibold">Active</span>
                        @else
                            <span class="text-red-400 font-semibold">Inactive</span>
                        @endif
                    </td>

                    <td class="px-4 py-3 flex gap-4">

                        {{-- Edit --}}
                        <a href="{{ route('admin.account_types.edit', $type->id) }}"
                           class="text-blue-400 hover:text-blue-600">Edit</a>

                        {{-- Delete --}}
                        <form action="{{ route('admin.account_types.destroy', $type->id) }}"
                              method="POST"
                              onsubmit="return confirm('Delete this account type?');">
                            @csrf
                            @method('DELETE')
                            <button class="text-red-400 hover:text-red-600">Delete</button>
                        </form>

                        {{-- Activate / Deactivate --}}
                        <form action="{{ route('admin.account_types.toggle_status', $type->id) }}" method="POST">
                            @csrf
                            <button class="text-yellow-400 hover:text-yellow-600">
                                {{ $type->status === 'active' ? 'Deactivate' : 'Activate' }}
                            </button>
                        </form>

                    </td>
                </tr>
                @endforeach
            </tbody>

        </table>
    </div>

</div>
@endsection
