@extends('layouts.admin')

@section('content')
<div class="p-6">
    <h2 class="text-2xl font-bold text-white mb-4">Edit Group</h2>

    <form action="{{ route('admin.groups.update', $group->id) }}" method="POST" class="bg-gray-800 p-6 rounded">
        @csrf @method('PUT')

        <label class="block text-gray-300">Group Name</label>
        <input name="name" class="w-full p-2 rounded bg-gray-700 text-white mb-3" value="{{ old('name', $group->name) }}" required>

        <label class="block text-gray-300">Notes</label>
        <textarea name="notes" class="w-full p-2 rounded bg-gray-700 text-white mb-3">{{ old('notes', $group->notes) }}</textarea>

        <label class="block text-gray-300">Status</label>
        <select name="status" class="w-full p-2 rounded bg-gray-700 text-white mb-3">
            <option value="active" {{ $group->status=='active' ? 'selected' : '' }}>Active</option>
            <option value="inactive" {{ $group->status=='inactive' ? 'selected' : '' }}>Inactive</option>
        </select>

        <div class="flex gap-2">
            <button class="px-4 py-2 bg-blue-600 rounded text-white">Save</button>
            <a href="{{ route('admin.groups.index') }}" class="px-4 py-2 bg-gray-600 rounded text-white">Cancel</a>
        </div>
    </form>
</div>
@endsection
