@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-2xl font-bold text-white">Groups</h2>
        <a href="{{ route('admin.groups.create') }}" class="px-4 py-2 bg-indigo-600 rounded text-white">New Group</a>
    </div>

    @if(session('success')) <div class="mb-3 p-3 bg-green-600 text-white">{{ session('success') }}</div> @endif
    @if(session('error')) <div class="mb-3 p-3 bg-red-600 text-white">{{ session('error') }}</div> @endif

    <div class="bg-gray-800 rounded p-4">
        <table class="w-full text-left text-gray-200">
            <thead class="text-gray-400">
                <tr>
                    <th class="py-2">Name</th>
                    <th>Active Members</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($groups as $g)
                    <tr class="border-t border-gray-700">
                        <td class="py-2">{{ $g->name }}</td>
                        <td>{{ $g->active_members_count ?? 0 }}</td>
                        <td>{{ ucfirst($g->status) }}</td>
                        <td>
                            <a href="{{ route('admin.groups.show', $g->id) }}" class="text-blue-400">View</a>
                            <a href="{{ route('admin.groups.edit', $g->id) }}" class="ml-3 text-yellow-400">Edit</a>
                            <form action="{{ route('admin.groups.destroy', $g->id) }}" method="POST" class="inline-block ml-3" onsubmit="return confirm('Delete group?');">
                                @csrf @method('DELETE')
                                <button class="text-red-400">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="4" class="py-4 text-gray-400">No groups yet.</td></tr>
                @endforelse
            </tbody>
        </table>

        <div class="mt-4">
            {{ $groups->links() }}
        </div>
    </div>
</div>
@endsection
