@extends('layouts.admin')

@section('content')
<div class="p-6 text-gray-100">

    <div class="flex justify-between mb-4">
        <h1 class="text-2xl font-bold">Income Types</h1>

        <a href="{{ route('admin.income_types.create') }}"
           class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">
            + Add Income Type
        </a>
    </div>

    <table class="w-full bg-gray-800 text-left rounded overflow-hidden">
        <thead class="bg-gray-700 text-gray-300">
            <tr>
                <th class="p-3">Name</th>
                <th class="p-3">Description</th>
                <th class="p-3">Action</th>
            </tr>
        </thead>

        <tbody>
            @foreach($types as $type)
            <tr class="border-b border-gray-700">
                <td class="p-3">{{ $type->name }}</td>
                <td class="p-3">{{ $type->description }}</td>

                <td class="p-3">
                    <a href="{{ route('admin.income_types.edit', $type) }}"
                       class="text-blue-400 hover:text-blue-200">Edit</a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="mt-4">
        {{ $types->links() }}
    </div>

</div>
@endsection
