@extends('layouts.admin')

@section('content')
<div class="p-6 text-gray-100">

    <div class="flex justify-between mb-6">
        <h1 class="text-2xl font-bold">Income Dashboard</h1>
        <a href="{{ route('admin.incomes.index') }}"
           class="bg-gray-700 px-4 py-2 rounded hover:bg-gray-600">
            View All Income Records
        </a>
    </div>

    {{-- KPI CARDS --}}
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-8">
        <div class="bg-gray-800 p-4 rounded shadow">
            <p class="text-xs uppercase text-gray-400">Total Income (All Time)</p>
            <p class="text-2xl font-bold text-green-400 mt-2">
                UGX {{ number_format($totalIncome, 0) }}
            </p>
        </div>

        <div class="bg-gray-800 p-4 rounded shadow">
            <p class="text-xs uppercase text-gray-400">This Month</p>
            <p class="text-2xl font-bold text-blue-400 mt-2">
                UGX {{ number_format($totalThisMonth, 0) }}
            </p>
        </div>

        <div class="bg-gray-800 p-4 rounded shadow">
            <p class="text-xs uppercase text-gray-400">Today</p>
            <p class="text-2xl font-bold text-yellow-400 mt-2">
                UGX {{ number_format($totalToday, 0) }}
            </p>
        </div>

        <div class="bg-gray-800 p-4 rounded shadow">
            <p class="text-xs uppercase text-gray-400">Total Transactions</p>
            <p class="text-2xl font-bold text-purple-400 mt-2">
                {{ number_format($totalTransactions) }}
            </p>
        </div>
    </div>

    {{-- CHARTS SECTION --}}
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">

        {{-- Income by Type --}}
        <div class="bg-gray-800 p-4 rounded shadow col-span-1 lg:col-span-1">
            <h2 class="text-lg font-semibold mb-4">Income by Type</h2>
            <canvas id="incomeByTypeChart" height="200"></canvas>
        </div>

        {{-- Monthly Trend --}}
        <div class="bg-gray-800 p-4 rounded shadow col-span-1 lg:col-span-2">
            <h2 class="text-lg font-semibold mb-4">Monthly Income (Last 6 Months)</h2>
            <canvas id="monthlyIncomeChart" height="100"></canvas>
        </div>
    </div>

    {{-- PAYMENT BREAKDOWN + TOP MEMBERS --}}
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">

    

        {{-- Top Members --}}
        <div class="bg-gray-800 p-4 rounded shadow lg:col-span-2">
            <h2 class="text-lg font-semibold mb-4">Top Contributing Members</h2>
            <table class="w-full text-sm">
                <thead class="bg-gray-700 text-gray-300">
                    <tr>
                        <th class="p-2 text-left">Member</th>
                        <th class="p-2 text-left">Total Income</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($topMembers as $row)
                        <tr class="border-b border-gray-700">
                            <td class="p-2">
                                {{ $row->member->name ?? 'Unknown' }}
                                @if($row->member)
                                    <span class="text-xs text-gray-400 block">
                                        {{ $row->member->member_id }}
                                    </span>
                                @endif
                            </td>
                            <td class="p-2 text-green-400">
                                UGX {{ number_format($row->total, 0) }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="2" class="p-3 text-gray-400 text-center">
                                No member-linked income yet.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

    </div>

    {{-- RECENT INCOME TABLE --}}
    <div class="bg-gray-800 p-4 rounded shadow">
        <h2 class="text-lg font-semibold mb-4">Recent Income Activity</h2>

        <table class="w-full text-left text-sm">
            <thead class="bg-gray-700 text-gray-300">
                <tr>
                    <th class="p-2">Date</th>
                    <th class="p-2">Receipt</th>
                    <th class="p-2">Type</th>
                    <th class="p-2">Member</th>
                    <th class="p-2">Amount</th>
                    <th class="p-2">Payment</th>
                    <th class="p-2">Recorded By</th>
                </tr>
            </thead>

            <tbody>
                @forelse($recentIncomes as $inc)
                    <tr class="border-b border-gray-700">
                        <td class="p-2">{{ $inc->income_date }}</td>
                        <td class="p-2">{{ $inc->receipt_no }}</td>
                        <td class="p-2">{{ $inc->type->name ?? 'N/A' }}</td>
                        <td class="p-2">{{ $inc->member->name ?? '—' }}</td>
                        <td class="p-2 text-green-400">
                            UGX {{ number_format($inc->amount, 0) }}
                        </td>
                        <td class="p-2">
                            {{ ucfirst(str_replace('_', ' ', $inc->payment_method)) }}
                        </td>
                        <td class="p-2">{{ $inc->admin->name ?? 'N/A' }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="p-3 text-center text-gray-400">
                            No recent incomes recorded.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

</div>

{{-- CHART.JS --}}
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Income by Type
    const incomeByTypeLabels = @json($incomeByType->pluck('type.name'));
    const incomeByTypeData   = @json($incomeByType->pluck('total'));

    const ctxType = document.getElementById('incomeByTypeChart').getContext('2d');
    new Chart(ctxType, {
        type: 'bar',
        data: {
            labels: incomeByTypeLabels,
            datasets: [{
                label: 'Total Income (UGX)',
                data: incomeByTypeData,
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: { beginAtZero: true }
            }
        }
    });

    // Monthly Income Trend
    const monthlyLabels = @json($monthlyIncome->pluck('month'));
    const monthlyData   = @json($monthlyIncome->pluck('total'));

    const ctxMonthly = document.getElementById('monthlyIncomeChart').getContext('2d');
    new Chart(ctxMonthly, {
        type: 'line',
        data: {
            labels: monthlyLabels,
            datasets: [{
                label: 'Income (UGX)',
                data: monthlyData,
                tension: 0.3,
                fill: false,
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: { beginAtZero: true }
            }
        }
    });


    const ctxPayment = document.getElementById('paymentMethodChart').getContext('2d');
    new Chart(ctxPayment, {
        type: 'pie',
        data: {
            labels: paymentLabels,
            datasets: [{
                data: paymentData,
            }]
        },
        options: {
            responsive: true,
        }
    });
</script>
@endsection
