<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #444; padding: 6px; text-align: left; }
        th { background: #ddd; }
    </style>
</head>
<body>

<h2>Income Report</h2>
<p>Generated: {{ $generated_at }}</p>

<table>
    <thead>
        <tr>
            <th>Receipt</th>
            <th>Type</th>
            <th>Member</th>
            <th>Amount</th>
            <th>Payment</th>
            <th>Date</th>
            <th>Recorded By</th>
        </tr>
    </thead>

    <tbody>
        @foreach($incomes as $inc)
        <tr>
            <td>{{ $inc->receipt_no }}</td>
            <td>{{ $inc->type->name }}</td>
            <td>{{ $inc->member->name ?? '—' }}</td>
            <td>UGX {{ number_format($inc->amount) }}</td>
            <td>{{ ucfirst($inc->payment_method) }}</td>
            <td>{{ $inc->income_date }}</td>
            <td>{{ $inc->admin->name }}</td>
        </tr>
        @endforeach
    </tbody>
</table>

</body>
</html>
