@extends('layouts.admin')

@section('content')
<div class="p-6">
    <h2 class="text-2xl font-bold text-white mb-4">New Loan Type</h2>

    <form action="{{ route('admin.loan-types.store') }}" method="POST" class="bg-gray-800 p-6 rounded">
        @csrf

        <label class="block text-gray-300">Name</label>
        <input name="name" class="w-full p-2 rounded bg-gray-700 text-white mb-3" required>

        <label class="block text-gray-300">Description</label>
        <textarea name="description" class="w-full p-2 rounded bg-gray-700 text-white mb-3"></textarea>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
            <div>
                <label class="block text-gray-300">Interest Rate (%)</label>
                <input name="interest_rate" class="w-full p-2 rounded bg-gray-700 text-white" />
            </div>
            <div>
                <label class="block text-gray-300">Duration (months)</label>
                <input name="duration_months" class="w-full p-2 rounded bg-gray-700 text-white" />
            </div>
            <div>
                <label class="block text-gray-300">Min Amount</label>
                <input name="min_amount" class="w-full p-2 rounded bg-gray-700 text-white" />
            </div>
        </div>

        <label class="block text-gray-300 mt-3">Rules (JSON)</label>
        <textarea name="rules" class="w-full p-2 rounded bg-gray-700 text-white" rows="6" placeholder='{"min_savings_percent":50,"min_daily_saving_days":90}'></textarea>
        <p class="text-gray-400 text-sm mt-1">Use JSON to define rules (e.g. min_savings_percent, min_daily_saving_days, require_group_of)</p>

        <div class="mt-3 space-x-3">
            <label class="inline-flex items-center"><input type="checkbox" name="allow_member_application" checked> <span class="ml-2 text-gray-300">Allow Member Apply</span></label>
            <label class="inline-flex items-center"><input type="checkbox" name="allow_admin_application" checked> <span class="ml-2 text-gray-300">Allow Admin Apply</span></label>
            <label class="inline-flex items-center"><input type="checkbox" name="is_group_loan"> <span class="ml-2 text-gray-300">Is Group Loan</span></label>
        </div>

        <div class="mt-4">
            <button class="px-4 py-2 bg-green-600 rounded text-white">edit</button>
            <a href="{{ route('admin.loan-types.index') }}" class="px-4 py-2 bg-gray-600 rounded text-white ml-2">Cancel</a>
        </div>
    </form>
</div>
@endsection
