<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Member Statement - {{ $user->name }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; color: #222; font-size: 12px; }
        .header { text-align: center; margin-bottom: 12px; }
        .meta { margin-bottom: 10px; }
        .account-block { margin-top: 18px; page-break-inside: avoid; }
        table { width: 100%; border-collapse: collapse; margin-top: 6px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; font-size: 11px; }
        th { background: #f4f4f4; }
        .totals { margin-top: 8px; }
        .small { font-size: 10px; color: #666; }
    </style>
</head>
<body>
    <div class="header">
    @if(file_exists(public_path('images/hosanna-logo.png')))
    <p><div style="text-align:center; margin-bottom: 15px;">
        <img src="{{ public_path('images/hosanna-logo.png') }}" 
             alt="SACCO Logo"
             style="height:80px;">
    </div></p>
@endif


        <h2>MEMBER STATEMENT</h2>
        <div class="small">Generated: {{ $generated_at }}</div>
    </div>

    <div class="meta">
        <strong>Member:</strong> {{ $user->name }} ({{ $user->member_id }})<br>
        <strong>Phone:</strong> {{ $user->phone ?? 'N/A' }} &nbsp; | &nbsp;
        <strong>Email:</strong> {{ $user->email ?? 'N/A' }}<br>
        <strong>Address:</strong> {{ $user->address ?? 'N/A' }}<br>
        @if($date_from || $date_to)
            <strong>Period:</strong> {{ $date_from ?: 'START' }} → {{ $date_to ?: 'END' }}
        @endif
    </div>

    @foreach($accounts as $accBlock)
        <div class="account-block">
            <h4>Account: {{ $accBlock['account']->account_number }} — {{ $accBlock['account']->type->name ?? 'N/A' }} (Status: {{ $accBlock['account']->status }})</h4>

            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Description</th>
                        <th>DR (Debit)</th>
                        <th>CR (Credit)</th>
                        <th>Running Balance</th>
                        <th>Admin</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($accBlock['transactions'] as $r)
                        <tr>
                            <td>{{ $r['date'] }}</td>
                            <td>{{ $r['description'] }}</td>
                            <td style="text-align:right">{{ $r['dr'] }}</td>
                            <td style="text-align:right">{{ $r['cr'] }}</td>
                            <td style="text-align:right">{{ $r['running'] }}</td>
                            <td>{{ $r['admin'] }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="6" style="text-align:center">No transactions for this account in the selected period.</td></tr>
                    @endforelse
                </tbody>
            </table>

            <div class="totals">
                <strong>Account Totals:</strong>
                DR: {{ number_format($accBlock['totals']['dr'], 2) }} |
                CR: {{ number_format($accBlock['totals']['cr'], 2) }} |
                Net: {{ number_format($accBlock['totals']['net'], 2) }}
            </div>
        </div>
    @endforeach

    <div style="margin-top:18px; border-top:1px solid #ddd; padding-top:8px;">
        <strong>Member Totals:</strong>
        DR: {{ number_format($memberTotals['dr'], 2) }} |
        CR: {{ number_format($memberTotals['cr'], 2) }} |
        Net: {{ number_format($memberTotals['net'], 2) }}
    </div>

    <div class="small" style="margin-top:16px;">
        This statement was generated by the system. For queries contact your SACCO administrator.
    </div>
</body>
</html>
