@extends('layouts.admin')

@section('content')
<div class="p-6 text-gray-100 max-w-xl">

    <h1 class="text-xl font-bold mb-4">
        Record Shares Purchase for {{ $user->name }}
    </h1>

    <form method="POST" action="{{ route('admin.shares.store', $user->id) }}"
          class="space-y-4 bg-gray-800 p-6 rounded">
        
        @csrf

        <div>
            <label class="text-sm">Amount (UGX)</label>
            <input type="number" name="amount" class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="text-sm">Price Per Share (UGX)</label>
            <input type="number" name="price_per_share" class="w-full bg-gray-700 px-3 py-2 rounded" required>
        </div>

        <div>
            <label class="text-sm">Notes (optional)</label>
            <textarea name="notes" rows="2" class="w-full bg-gray-700 px-3 py-2 rounded"></textarea>
        </div>

        <button class="px-4 py-2 bg-blue-600 rounded hover:bg-blue-700">
            Record Purchase
        </button>

    </form>
</div>
@endsection
