@extends('layouts.admin')

@section('content')
<div class="p-6 max-w-2xl mx-auto">
    <h2 class="text-2xl font-semibold text-gray-100 mb-4">Edit User</h2>

    <form action="{{ route('users.update', $user->id) }}" enctype="multipart/form-data" method="POST" class="space-y-4 bg-gray-800 p-6 rounded-lg shadow">
        @csrf
        @method('PUT')

        <div>
            <label class="block text-sm text-gray-300">Name</label>
            <input type="text" name="name" value="{{ $user->name }}" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white" required>
        </div>

        <div>
            <label class="block text-sm text-gray-300">Phone</label>
            <input type="text" name="phone" value="{{ $user->phone }}" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
        </div>
        <div class="mb-4">
            <label class="block text-gray-300 mb-2">Profile Photo</label>
            <input type="file" name="photo"
                class="w-full text-white bg-gray-700 border border-gray-600 rounded px-3 py-2">
        </div>

        <div>
            <label class="block text-sm text-gray-300">Address</label>
            <input type="text" name="address" value="{{ $user->address }}" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
        </div>

        <div>
            <label class="block text-sm text-gray-300">National ID</label>
            <input type="text" name="national_id" value="{{ $user->national_id }}" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
        </div>

        <div>
            <label class="block text-sm text-gray-300">Role</label>
            <select name="role" class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
                <option value="member" @selected($user->role == 'member')>Member</option>
                <option value="admin" @selected($user->role == 'admin')>Admin</option>
                <option value="member" @selected($user->role == 'loan_officer')>Loan officer</option>
                <option value="admin" @selected($user->role == 'accountant')>Accountant</option>
            </select>
        </div>
        <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">Update User</button>
        <a href="{{ route('users.index') }}" class="text-gray-400 ml-4 hover:text-gray-300">Cancel</a>
    </form>
</div>
@endsection
