@extends('layouts.admin')

@section('content')

<div class="p-6 bg-gray-900 text-gray-200 min-h-screen">

    {{-- Page Header --}}
    <div class="flex justify-between items-center mb-8">
        <div class="flex items-center space-x-4">

@if(session('new_password'))    
    <div class="p-4 bg-green-800 text-green-200 rounded mb-4">
        <strong>New Password:</strong>
        <span class="font-mono">{{ session('new_password') }}</span>
        <p class="text-xs text-gray-300 mt-1">Give this password to the user. They should change it after login.</p>
    </div>
@endif


            {{-- PROFILE PHOTO --}}
            <div>
                @if($user->photo)
                    <img src="{{ asset('storage/photos/' . $user->photo) }}"
                         class="w-20 h-20 rounded-full object-cover border-2 border-blue-600 shadow">
                @else
                    <div class="w-20 h-20 rounded-full bg-gray-700 flex items-center justify-center text-3xl font-bold">
                        {{ strtoupper(substr($user->name, 0, 1)) }}
                    </div>
                @endif
            </div>

            <div>
                <h1 class="text-3xl font-bold">{{ $user->name }}</h1>
                <p class="text-gray-400 text-sm">Member ID: {{ $user->member_id }}</p>
            </div>
        </div>

        <div class="space-x-3">
            <a href="{{ route('admin.users.statement', ['user' => $user->id, 'date_from' => request('date_from'), 'date_to' => request('date_to')]) }}"
   class="px-4 py-2 bg-indigo-600 hover:bg-indigo-700 rounded text-white">
 Member Statement (PDF)
</a>

            <a href="{{ route('users.edit', $user->id) }}"
               class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded text-white">
               Edit User
            </a>

            <a href="{{ route('admin.accounts.create') }}?member={{ $user->id }}"
               class="px-4 py-2 bg-green-600 hover:bg-green-700 rounded text-white">
               Create Account
            </a>

             <a href="{{ route('admin.shares.create', ['user' => $user->id]) }}"
   class="px-4 py-2 bg-orange-600 hover:bg-orange-700 rounded text-white">
    Add Share
</a>

<form action="{{ route('admin.users.reset-password', $user->id) }}" method="POST" class="inline">
    @csrf
    <button class="px-3 py-2 bg-red-600 hover:bg-red-700 text-white rounded">
        Reset Password
    </button>
</form>


        </div>
    </div>

    {{-- User Info + Status Actions --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

        {{-- Left Column: User Info --}}
        <div class="md:col-span-2 bg-gray-800 p-6 rounded shadow">
            <h2 class="text-xl font-semibold mb-4">User Information</h2>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-gray-300">

                <p><strong>Email:</strong> {{ $user->email }}</p>
                <p><strong>Phone:</strong> {{ $user->phone ?? 'N/A' }}</p>

                <p><strong>National ID:</strong> {{ $user->national_id ?? 'N/A' }}</p>
                <p><strong>Address:</strong> {{ $user->address ?? 'N/A' }}</p>

                <p><strong>Role:</strong> {{ ucfirst($user->role) }}</p>

                <p class="flex items-center">
                    <strong>Status:</strong>
                    <span class="ml-2 px-3 py-1 text-sm rounded
                        @if($user->status === 'active') bg-green-700 text-green-200
                        @elseif($user->status === 'inactive') bg-red-700 text-red-200
                        @else bg-yellow-700 text-yellow-200
                        @endif
                    ">
                        {{ ucfirst($user->status) }}
                    </span>
                </p>

                <p><strong>Created:</strong> {{ $user->created_at->format('Y-m-d') }}</p>

            </div>

        </div>

        {{-- SHARE SUMMARY SECTION --}}
<div class="bg-gray-800 p-6 rounded shadow mt-10">
    <h2 class="text-lg font-semibold mb-4">Share Ownership Summary</h2>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 text-gray-300">

        <div class="p-4 bg-gray-900 rounded shadow">
            <p class="text-sm text-gray-400">Total Shares Owned</p>
            <p class="text-3xl font-bold text-blue-400">
                {{ number_format($totalShares) }}
            </p>
        </div>

        <div class="p-4 bg-gray-900 rounded shadow">
            <p class="text-sm text-gray-400">Total Share Value</p>
            <p class="text-3xl font-bold text-green-400">
                UGX {{ number_format($totalShareValue) }}
            </p>
        </div>

    </div>
</div>


    </div>

    {{-- ACCOUNTS SECTION --}}
<div class="bg-gray-800 p-6 rounded shadow mt-10">
    <h2 class="text-lg font-semibold mb-4">Accounts</h2>

    @if($accounts->isEmpty())
        <p class="text-gray-400">No accounts found.</p>
    @else
        <table class="w-full text-left">
            <thead>
                <tr class="text-gray-400">
                    <th class="py-2">Account Number</th>
                    <th class="py-2">Type</th>
                    <th class="py-2">Balance</th>
                    <th class="py-2">Status</th>
                </tr>
            </thead>
            <tbody class="text-gray-300">
                @foreach ($accounts as $account)
                    <tr class="border-b border-gray-700">
                        <td class="py-2">
                            <a href="{{ route('admin.accounts.show', $account->id) }}" 
                               class="text-blue-400 hover:underline">
                                {{ $account->account_number }}
                            </a>
                        </td>
                        <td class="py-2">{{ $account->type->name ?? 'N/A' }}</td>
                        <td class="py-2">UGX {{ number_format($account->balance) }}</td>
                        <td class="py-2">
                            <span class="
                                px-3 py-1 text-sm rounded
                                @if($account->status=='active') bg-green-700 text-green-200
                                @else bg-red-700 text-red-200
                                @endif
                            ">
                                {{ ucfirst($account->status) }}
                            </span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>


      {{-- Transaction SECTION --}}
<div class="bg-gray-800 p-6 rounded shadow mt-10">
    <h2 class="text-lg font-semibold mb-4">Recent Transactions</h2>

    @if($transactions->isEmpty())
        <p class="text-gray-400">No recent transactions.</p>
    @else
        <table class="w-full text-left">
            <thead>
                <tr class="text-gray-400">
                    <th class="py-2">Date</th>
                    <th class="py-2">Account</th>
                    <th class="py-2">Type</th>
                    <th class="py-2">Amount</th>
                    <th class="py-2">Before</th>
                    <th class="py-2">After</th>
                </tr>
            </thead>
            <tbody class="text-gray-300">
                @foreach ($transactions as $tx)
                    <tr class="border-b border-gray-700">
                        <td class="py-2">{{ $tx->created_at->format('Y-m-d H:i') }}</td>
                        <td class="py-2">
                            <a href="{{ route('admin.accounts.show', $tx->account_id) }}" 
                               class="text-blue-400 hover:underline">
                                {{ $tx->account->account_number }}
                            </a>
                        </td>
                        <td class="py-2">{{ ucfirst($tx->type) }}</td>
                        <td class="py-2">UGX {{ number_format($tx->amount) }}</td>
                        <td class="py-2">{{ number_format($tx->balance_before) }}</td>
                        <td class="py-2">{{ number_format($tx->balance_after) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>


</div>

@endsection
