<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Hosanna Sacco</title>
    @vite('resources/css/app.css')
</head>

<body class="bg-gray-900 text-gray-200 flex min-h-screen">

    <!-- Sidebar -->
    <!-- Sidebar -->
<aside class="w-64 bg-gray-800 text-white flex flex-col">
    <div class="p-6 text-center border-b border-gray-600">
        <h1 class="text-xl font-bold">HOSANNA SACCO</h1>
        <p class="text-sm">Admin Panel</p>
    </div>


    <nav class="flex-1 p-4 space-y-2">

    {{-- Dashboard --}}
    <a href="{{ route('admin.dashboard') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
        🏠 Dashboard
    </a>
     {{-- Policies  --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Polices & Shares</p>

        <a href="{{ route('admin.policies.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            Policies
        </a>
        <a href="{{ route('admin.shares.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            Shares
        </a>
    </div>

      {{-- Expenses  --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Expenses </p>

        <a href="{{ route('admin.expenses.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            Expenses 
        </a>
    </div>

    {{-- INCOME --}}
<div class="mt-4">
    <p class="text-xs uppercase text-blue-300">Income</p>

      <a href="{{ route('admin.incomes.dashboard') }}"
       class="block py-2 px-3 rounded hover:bg-blue-700">
        📊 Income Dashboard
    </a>

    <a href="{{ route('admin.income_types.index') }}"
       class="block py-2 px-3 rounded hover:bg-blue-700">
        ➕  Income Types
    </a>

    <a href="{{ route('admin.incomes.index') }}"
       class="block py-2 px-3 rounded hover:bg-blue-700">
        📋 Income Records
    </a>

</div>


    {{-- USERS --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Users</p>

        <a href="{{ route('admin.users.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            📋 View Users
        </a>

        <a href="{{ route('admin.users.create') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            ➕ Add User
        </a>
    </div>

    {{-- ACCOUNT TYPES --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Account Types</p>

        <a href="{{ route('admin.account_types.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            🧩 Account Types
        </a>
    </div>

    {{-- ACCOUNTS --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Accounts</p>

        <a href="{{ route('admin.accounts.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            📊 View Accounts
        </a>

        <a href="{{ route('admin.accounts.create') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            ➕ Create Account
        </a>

        <a href="{{ route('admin.transactions.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            💳 Transactions
        </a>
    </div>

    {{-- GROUPS --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Groups</p>

        <a href="{{ route('admin.groups.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            👥 View Groups
        </a>

        <a href="{{ route('admin.groups.create') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            ➕ Create Group
        </a>

        <a href="{{ route('admin.group_loans.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            🗂️ Group Loans
        </a>
    </div>

    {{-- LOAN TYPES --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Loan Types</p>

        <a href="{{ route('admin.loan_types.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            🗂️ Loan Types
        </a>
    </div>

    {{-- INDIVIDUAL LOANS --}}
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Loans</p>

        @if(auth()->user()->role === 'admin')
            <a href="{{ route('admin.loans.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
                📑 All Loans
            </a>
        @endif

        {{-- LOAN OFFICER MENU --}}
@if(auth()->user()->role === 'loan_officer')
    <div class="mt-4">
        <p class="text-xs uppercase text-blue-300">Loan Officer</p>

        <a href="{{ route('loan_officer.loans.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
            📌 Pending & Approved Loans
        </a>
    </div>
@endif


        {{-- Member Menu --}}
        @if(auth()->user()->role === 'member')
            <a href="{{ route('member.loans.apply') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
                📝 Apply for Loan
            </a>

            <a href="{{ route('member.loans.index') }}" class="block py-2 px-3 rounded hover:bg-blue-700">
                📚 My Loans
            </a>
        @endif
    </div>

    {{-- SETTINGS --}}
    <a href="#" class="block py-2 px-3 rounded hover:bg-blue-700 mt-6">
        ⚙️ Settings
    </a>
</nav>

 
    {{-- Logout --}}
    <div class="p-4 border-t border-blue-700">
        <form action="{{ route('logout') }}" method="POST">
            @csrf
            <button class="w-full text-left py-2 px-3 rounded hover:bg-blue-700">
                🚪 Logout
            </button>
        </form>
    </div>
</aside>
    <!-- Main Content -->
    <main class="flex-1 p-6">
        @yield('content')
    </main>

</body>
</html>
