@extends('layouts.loan_officer')

@section('content')

<div class="p-6 space-y-8">

    {{-- PAGE TITLE --}}
    <div>
        <h2 class="text-3xl font-bold text-gray-100">Loan Officer Dashboard</h2>
        <p class="text-gray-400 mt-1">
            Welcome, {{ auth()->user()->name }}. Review and take action on loan applications.
        </p>
    </div>

    {{-- STAT CARDS --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

        <div class="bg-gray-800 p-4 rounded shadow border-l-4 border-yellow-500">
            <h3 class="text-gray-400 text-sm">Pending Loans</h3>
            <p class="text-2xl font-bold text-yellow-400">{{ $stats['pending'] }}</p>
        </div>

        <div class="bg-gray-800 p-4 rounded shadow border-l-4 border-blue-500">
            <h3 class="text-gray-400 text-sm">Approved & Awaiting Disbursement</h3>
            <p class="text-2xl font-bold text-blue-400">{{ $stats['approved'] }}</p>
        </div>

        <div class="bg-gray-800 p-4 rounded shadow border-l-4 border-purple-500">
            <h3 class="text-gray-400 text-sm">Active Loans</h3>
            <p class="text-2xl font-bold text-purple-400">{{ $stats['active'] }}</p>
        </div>

    </div>

    {{-- LOANS TABLE --}}
    <div class="bg-gray-800 p-6 rounded shadow">
        <h3 class="text-xl font-semibold text-gray-100 mb-4">Loans Needing Action</h3>

        <table class="w-full text-left text-gray-200">
            <thead class="bg-gray-700 text-gray-400">
                <tr>
                    <th class="p-2">Member</th>
                    <th>Type</th>
                    <th>Principal</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>

            <tbody>
            @forelse($loans as $loan)
                <tr class="border-t border-gray-700 hover:bg-gray-700">

                    <td class="p-2">
                        {{ $loan->user->name }}<br>
                        <span class="text-xs text-gray-400">{{ $loan->user->member_id }}</span>
                    </td>

                    <td class="p-2">
                        {{ $loan->loanType->name }}
                    </td>

                    <td class="p-2">
                        UGX {{ number_format($loan->principal) }}
                    </td>

                    <td class="p-2">
                        <span class="px-2 py-1 text-xs rounded 
                            @if($loan->status=='pending') bg-yellow-600 
                            @elseif($loan->status=='approved') bg-blue-600 
                            @elseif($loan->status=='active') bg-purple-600 
                            @else bg-gray-600 @endif">
                            {{ ucfirst($loan->status) }}
                        </span>
                    </td>

                    <td class="p-2">
                        {{ $loan->created_at->format('Y-m-d') }}
                    </td>

                    <td class="p-2 text-right">
                        <a href="{{ route('loan_officer.loans.show', $loan->id) }}"
                           class="text-blue-400 hover:underline">
                            View
                        </a>
                    </td>

                </tr>
            @empty
                <tr>
                    <td colspan="6" class="py-6 text-center text-gray-500">
                        No loans to review at the moment.
                    </td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </div>

</div>
@endsection
