@extends('layouts.loan_officer')

@section('content')
<div class="p-6 space-y-6">

    <h2 class="text-2xl font-semibold text-gray-100">
        Loan #{{ $loan->id }} Details
    </h2>

    <div class="bg-gray-800 p-6 rounded shadow space-y-4">

        <p><strong>Member:</strong> {{ $loan->user->name }} 
            <span class="text-gray-400 text-sm">({{ $loan->user->member_id }})</span>
        </p>

        <p><strong>Loan Type:</strong> {{ $loan->loanType->name }}</p>
        <p><strong>Principal:</strong> UGX {{ number_format($loan->principal) }}</p>
        <p><strong>Status:</strong> {{ ucfirst($loan->status) }}</p>
        <p><strong>Balance:</strong> UGX {{ number_format($loan->balance) }}</p>

        <hr class="border-gray-700">

        {{-- ACTION BUTTONS --}}
        <div class="flex gap-3">

            {{-- APPROVE --}}
            @if($loan->status === 'pending')
                <form action="{{ route('loan_officer.loans.approve', $loan->id) }}" method="POST">
                    @csrf
                    <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded">
                        Approve
                    </button>
                </form>

                {{-- REJECT --}}
                <form action="{{ route('loan_officer.loans.reject', $loan->id) }}" method="POST">
                    @csrf
                    <button class="px-4 py-2 bg-red-600 hover:bg-red-700 rounded">
                        Reject
                    </button>
                </form>
            @endif

            {{-- DISBURSE --}}
            @if($loan->status === 'approved')
                <form action="{{ route('loan_officer.loans.disburse', $loan->id) }}" method="POST">
                    @csrf
                    <button class="px-4 py-2 bg-purple-600 hover:bg-purple-700 rounded">
                        Disburse
                    </button>
                </form>
            @endif

            {{-- CLOSE --}}
            @if($loan->status === 'active' && $loan->balance == 0)
                <form action="{{ route('loan_officer.loans.close', $loan->id) }}" method="POST">
                    @csrf
                    <button class="px-4 py-2 bg-green-600 hover:bg-green-700 rounded">
                        Close Loan
                    </button>
                </form>
            @endif

        </div>

    </div>
</div>
@endsection
