@extends('layouts.member')

@section('content')

<div class="p-6">

    <h1 class="text-3xl font-bold text-white mb-6">My Loans</h1>

    @if($loans->isEmpty())
        <!-- Empty State -->
        <div class="bg-gray-800 p-10 rounded-xl text-center shadow-lg border border-gray-700">
            <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" class="mx-auto w-32 opacity-70 mb-4">
            <h2 class="text-xl font-semibold text-gray-300">No Loans Found</h2>
            <p class="text-gray-400 mt-2">You haven’t applied for any loan yet.</p>

            <a href="{{ route('member.loans.apply') }}"
               class="mt-4 inline-block px-5 py-2 bg-blue-600 rounded-lg text-white hover:bg-blue-700 transition">
                Apply for a Loan
            </a>
        </div>

    @else

        <!-- Loan List Table -->
        <div class="bg-gray-800 p-6 rounded-xl shadow-lg border border-gray-700">
            <table class="w-full text-left text-gray-200">
                <thead class="bg-gray-700 text-gray-300 uppercase text-sm">
                    <tr>
                        <th class="p-3">Loan Type</th>
                        <th class="p-3">Amount</th>
                        <th class="p-3">Status</th>
                        <th class="p-3">Applied On</th>
                        <th class="p-3 text-right">Actions</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($loans as $loan)
                        <tr class="border-b border-gray-700 hover:bg-gray-750 transition">
                            
                            <!-- Loan Type -->
                            <td class="p-3 flex items-center gap-2">
                                <div class="bg-blue-600 w-8 h-8 flex items-center justify-center rounded-full text-white">
                                    <span class="text-lg">💰</span>
                                </div>
                                {{ $loan->loanType->name ?? 'N/A' }}
                            </td>

                            <!-- Amount -->
                            <td class="p-3 font-semibold text-green-400">
                                UGX {{ number_format($loan->principal) }}
                            </td>

                            <!-- Status with colored badges -->
                            <td class="p-3">
                                @php
                                    $colors = [
                                        'pending' => 'bg-yellow-500',
                                        'approved' => 'bg-blue-500',
                                        'active' => 'bg-indigo-500',
                                        'rejected' => 'bg-red-600',
                                        'closed' => 'bg-green-600',
                                        'disbursed' => 'bg-purple-600',
                                    ];
                                @endphp

                                <span class="px-3 py-1 rounded-full text-sm font-semibold text-white
                                    {{ $colors[$loan->status] ?? 'bg-gray-600' }}">
                                    {{ ucfirst($loan->status) }}
                                </span>
                            </td>

                            <!-- Created Date -->
                            <td class="p-3 text-gray-300">
                                {{ $loan->created_at->format('d M Y') }}
                            </td>

                            <!-- Actions -->
                            <td class="p-3 text-right">
                                <a href="{{ route('member.loans.show', $loan->id) }}"
                                   class="px-4 py-1 rounded bg-blue-600 hover:bg-blue-700 text-white text-sm transition">
                                    View
                                </a>
                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    @endif
</div>

@endsection
