{{-- resources/views/member/policies/index.blade.php --}}
@extends('layouts.member')

@section('content')
<div class="max-w-4xl mx-auto px-4 lg:px-0 py-8">

    <h1 class="text-3xl font-semibold text-white mb-6">Policies & Agreements</h1>

    @foreach($policies as $policy)
    <article class="mb-6 bg-gray-800 rounded-lg border border-gray-700 shadow-sm overflow-hidden">
        <header class="px-6 py-4 flex items-start justify-between gap-4">
            <div>
                <h2 class="text-xl font-semibold text-blue-300 mb-1">{{ $policy->title }}</h2>
                @if($policy->description)
                    <p class="text-sm text-gray-400">{{ $policy->description }}</p>
                @endif
            </div>

            <div class="text-right space-y-2">
                {{-- Version / meta --}}
                <div class="text-xs text-gray-400">Version: <span class="font-medium text-gray-200">{{ $policy->version ?? '1.0' }}</span></div>

                {{-- Download PDF (optional route) --}}
                <div>
@php
    $hasPdfRoute = \Illuminate\Support\Facades\Route::has('member.policies.pdf');
    $pdfUrl = $hasPdfRoute ? route('member.policies.pdf', $policy) : '#';
@endphp

<a href="{{ $pdfUrl }}"
   class="text-sm inline-flex items-center px-3 py-1 rounded bg-gray-700 hover:bg-gray-600 text-gray-200 {{ $hasPdfRoute ? '' : 'opacity-60 cursor-not-allowed' }}"
   @if(! $hasPdfRoute) title="PDF export not configured" @endif>
   ⤓ PDF
</a>

                </div>
            </div>
        </header>

        {{-- content area (constrained width for reading) --}}
        <div class="px-6 pb-6">
            <details class="mb-4">
                <summary class="text-yellow-300 cursor-pointer font-medium">▼ View Policy Content</summary>

                <div class="mt-3 text-gray-300 leading-relaxed prose prose-invert max-w-none">
                    {{-- Render markdown safely. Laravel 9+ supports Str::markdown; otherwise pre-render on controller. --}}
                    {!! \Illuminate\Support\Str::markdown($policy->content) !!}
                </div>
            </details>

            <div class="flex items-center justify-between">
                <div>
                    @if(in_array($policy->id, $userAgreements ?? []))
                        <span class="inline-flex items-center gap-2 px-3 py-1 rounded bg-emerald-900 text-emerald-300 text-sm font-semibold">
                            ✓ You already agreed to this policy.
                        </span>

                        {{-- optionally show agreed version/time if you passed it --}}
                    @else
                        {{-- Agree form --}}
                        <form action="{{ route('member.policies.agree', $policy) }}" method="POST" class="inline">
                            @csrf
                            <button
                                type="submit"
                                class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500">
                                I Agree
                            </button>
                        </form>
                    @endif
                </div>

                <div class="text-sm text-gray-400">
                    <span>Published: </span>
                    <span class="font-medium text-gray-200">{{ optional($policy->created_at)->format('d M Y') ?? '-' }}</span>
                </div>
            </div>
        </div>
    </article>
    @endforeach

    @unless($policies->count())
        <div class="bg-gray-800 p-6 rounded-lg text-gray-400">
            No active policies available.
        </div>
    @endunless

</div>
@endsection

{{-- small helper: check route_exists in Blade (add in a service provider if you don't already have it) --}}
@once
@php
if (! function_exists('route_exists')) {
    function route_exists($name) {
        try {
            return \Illuminate\Support\Facades\Route::has($name);
        } catch (\Throwable $e) {
            return false;
        }
    }
}
@endphp
@endonce
