@extends('layouts.member')

@section('content')
<div class="p-6 text-gray-100">

    <h1 class="text-2xl font-bold mb-6">Member Statement</h1>

    {{-- ACCOUNT SELECTION --}}
    <form method="GET" class="mb-6">
        <label class="text-sm text-gray-300">Select Account</label>
        <select name="account_id" onchange="this.form.submit()"
            class="bg-gray-800 border border-gray-700 px-3 py-2 rounded w-full md:w-1/3">
            @foreach($accounts as $acc)
                <option value="{{ $acc->id }}" {{ $accountId == $acc->id ? 'selected' : '' }}>
                    {{ $acc->account_number }} — {{ $acc->type->name }}
                </option>
            @endforeach
        </select>
    </form>

    @if($accountId)

    {{-- ACCOUNT SUMMARY --}}
    <div class="bg-gray-800 border border-gray-700 p-5 rounded-lg shadow mb-6">
        <h2 class="text-xl font-bold text-blue-400 mb-4">Account Summary</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
            <p><span class="font-semibold">Account Number:</span> {{ $account->account_number }}</p>
            <p><span class="font-semibold">Statement Start:</span> {{ $statementStartDate->format('d M Y') }}</p>

            <p><span class="font-semibold">Opening Balance:</span>
                UGX {{ number_format($openingBalance) }}
            </p>

            <p><span class="font-semibold">Closing Balance:</span>
                UGX {{ number_format($closingBalance) }}
            </p>

            <p><span class="font-semibold">Total Credits:</span>
                UGX {{ number_format($totalCredit) }}
            </p>

            <p><span class="font-semibold">Total Debits:</span>
                UGX {{ number_format($totalDebit) }}
            </p>
        </div>
    </div>

    {{-- TRANSACTIONS TABLE --}}
    <div class="bg-gray-800 border border-gray-700 p-4 rounded">
        <table class="w-full text-sm text-gray-300">
            <thead class="bg-gray-700 text-gray-300">
                <tr>
                    <th class="p-2 text-left">Date</th>
                    <th class="p-2 text-left">Description</th>
                    <th class="p-2 text-right">Debit</th>
                    <th class="p-2 text-right">Credit</th>
                    <th class="p-2 text-right">Balance</th>
                </tr>
            </thead>

            <tbody>
                @forelse ($transactions as $tx)
                    <tr class="border-b border-gray-700">
                        <td class="p-2">{{ \Carbon\Carbon::parse($tx['date'])->format('d M Y H:i') }}</td>
                        <td class="p-2">{{ $tx['description'] }}</td>

                        <td class="p-2 text-right text-red-400">
                            {{ $tx['debit'] ? 'UGX '.number_format($tx['debit']) : '-' }}
                        </td>

                        <td class="p-2 text-right text-green-400">
                            {{ $tx['credit'] ? 'UGX '.number_format($tx['credit']) : '-' }}
                        </td>

                        <td class="p-2 text-right text-blue-300">
                            UGX {{ number_format($tx['balance']) }}
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="p-4 text-center text-gray-400">
                            No transactions found.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{-- EXPORT BUTTON --}}
    <div class="mt-4">
        <a href="{{ route('member.statement.pdf', ['account_id' => $accountId]) }}"
            class="px-4 py-2 bg-blue-600 rounded hover:bg-blue-700">
            Download PDF
        </a>
    </div>

    @endif

</div>
@endsection
