<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Member Statement</title>

    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { margin-bottom: 5px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #444; padding: 6px; text-align: left; }
        th { background: #f0f0f0; }
        .right { text-align: right; }
    </style>
</head>
<body>

<h2>Member Statement</h2>

<p><strong>Account:</strong> {{ $account->account_number }} ({{ $account->type->name }})</p>
<p><strong>Opening Balance:</strong> UGX {{ number_format($openingBalance) }}</p>
<p><strong>Closing Balance:</strong> UGX {{ number_format($closingBalance) }}</p>

<table>
    <thead>
        <tr>
            <th>Date</th>
            <th>Description</th>
            <th>Debit</th>
            <th>Credit</th>
            <th>Balance</th>
        </tr>
    </thead>

    <tbody>
        @foreach($transactions as $tx)
        <tr>
            <td>{{ $tx['date'] }}</td>
            <td>{{ $tx['description'] }}</td>
            <td class="right">{{ $tx['debit'] ? number_format($tx['debit']) : '-' }}</td>
            <td class="right">{{ $tx['credit'] ? number_format($tx['credit']) : '-' }}</td>
            <td class="right">{{ number_format($tx['balance']) }}</td>
        </tr>
        @endforeach
    </tbody>
</table>

</body>
</html>
