

<?php $__env->startSection('content'); ?>

<div class="p-6 bg-gray-900 text-gray-200 min-h-screen">

    
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-3xl font-bold"><?php echo e($account->account_number); ?></h1>
            <p class="text-gray-400">
                Account Type: <?php echo e($account->type->name); ?>

            </p>
            <p class="text-gray-400">
                Member: 
                <a href="<?php echo e(route('admin.users.show', $account->user_id)); ?>" 
                   class="text-blue-400 hover:underline">
                    <?php echo e($account->user->name); ?>

                </a>
            </p>
        </div>
    </div>


    
    <div class="bg-gray-800 rounded p-6 shadow mb-8">
        <h2 class="text-xl font-semibold mb-4">Account Summary</h2>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

            <div>
                <p class="text-gray-400">Balance</p>
                <p class="text-2xl font-bold text-green-400">
                    UGX <?php echo e(number_format($account->balance, 2)); ?>

                </p>
            </div>

            <div>
                <p class="text-gray-400">Status</p>
                <span class="
                    px-3 py-1 rounded text-sm
                    <?php if($account->status == 'active'): ?> bg-green-700 text-green-200
                    <?php else: ?> bg-red-700 text-red-200 
                    <?php endif; ?>
                ">
                    <?php echo e(ucfirst($account->status)); ?>

                </span>
            </div>

            <div>
                <p class="text-gray-400">Created On</p>
                <p><?php echo e($account->created_at->format('Y-m-d')); ?></p>
            </div>
        </div>
    </div>


    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-10">

        
        <div class="bg-gray-800 p-6 rounded shadow">
            <h3 class="text-lg font-semibold mb-4">Deposit</h3>

            <?php if(session('success_deposit')): ?>
                <p class="text-green-400 mb-2"><?php echo e(session('success_deposit')); ?></p>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.accounts.deposit', $account->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label class="block mb-1 text-gray-300">Amount</label>
                    <input type="number" step="0.01" name="amount"
                           class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600"
                           required>
                </div>

                <div class="mb-3">
                    <label class="block mb-1 text-gray-300">Description (optional)</label>
                    <input type="text" name="description"
                           class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600">
                </div>

                <button type="button"
        onclick="showDepositConfirm()"
        class="bg-green-600 hover:bg-green-700 text-white w-full py-2 rounded">
                    Deposit
                </button>
            </form>
        </div>


        
        <div class="bg-gray-800 p-6 rounded shadow">
            <h3 class="text-lg font-semibold mb-4">Withdraw</h3>

            <?php if(session('error')): ?>
                <p class="text-red-400 mb-2"><?php echo e(session('error')); ?></p>
            <?php elseif(session('success')): ?>
                <p class="text-green-400 mb-2"><?php echo e(session('success')); ?></p>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.accounts.withdraw', $account->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label class="block mb-1 text-gray-300">Amount</label>
                    <input type="number" step="0.01" name="withdraw_amount"
                           class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600"
                           required>
                </div>

                <div class="mb-3">
                    <label class="block mb-1 text-gray-300">Description (optional)</label>
                    <input type="text" name="withdraw_description"
                           class="w-full px-3 py-2 rounded bg-gray-700 border border-gray-600">
                </div>

                <button type="button"
        onclick="showWithdrawConfirm()"
        class="bg-red-600 hover:bg-red-700 text-white w-full py-2 rounded">
    Withdraw
</button>
            </form>
        </div>

    </div>


    
    <div class="bg-gray-800 rounded p-6 shadow">
        <h2 class="text-xl font-semibold mb-4">Transactions</h2>

        <?php if($transactions->isEmpty()): ?>
            <p class="text-gray-400">No transactions found.</p>
        <?php else: ?>
            <table class="w-full text-left">
                <thead>
                    <tr class="border-b border-gray-700 text-gray-400">
                        <th class="py-2">Date</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Before</th>
                        <th>After</th>
                        <th>Description</th>
                        <th>Admin</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b border-gray-700">
                            <td class="py-2"><?php echo e($t->created_at->format('Y-m-d H:i')); ?></td>
                            <td class="capitalize"><?php echo e($t->type); ?></td>
                            <td class="text-blue-300">UGX <?php echo e(number_format($t->amount, 2)); ?></td>
                            <td><?php echo e(number_format($t->balance_before, 2)); ?></td>
                            <td><?php echo e(number_format($t->balance_after, 2)); ?></td>
                            <td><?php echo e($t->description ?: '-'); ?></td>
                            <td><?php echo e($t->admin->name); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="mt-4">
                <?php echo e($transactions->links()); ?>

            </div>
        <?php endif; ?>
    </div>


    <dialog id="confirmDeposit" class="bg-white p-6 rounded shadow w-96">
    <h3 class="text-lg font-bold mb-2">Confirm Deposit</h3>

    <p id="depositText" class="text-sm mb-4 text-gray-700"></p>

    <form id="depositConfirmForm" method="POST">
        <?php echo csrf_field(); ?>
        
        <!-- Hidden fields -->
        <input type="hidden" name="amount" id="deposit_amount">
        <input type="hidden" name="description" id="deposit_description">

        <button class="px-4 py-2 bg-green-600 text-white rounded">Confirm</button>
        <button type="button" onclick="confirmDeposit.close()" class="px-3 py-2 bg-gray-400 rounded ml-2">
            Cancel
        </button>
    </form>
</dialog>

<!-- WITHDRAW MODAL -->
<dialog id="confirmWithdraw" class="bg-white p-6 rounded shadow w-96">
    <h3 class="text-lg font-bold mb-2">Confirm Withdrawal</h3>

    <p id="withdrawText" class="text-sm mb-4 text-gray-700"></p>

    <form id="withdrawConfirmForm" method="POST">
        <?php echo csrf_field(); ?>

        <!-- Hidden fields -->
        <input type="hidden" name="amount" id="withdraw_amount">
        <input type="hidden" name="description" id="withdraw_description">

        <button class="px-4 py-2 bg-red-600 text-white rounded">Confirm</button>
        <button type="button" onclick="confirmWithdraw.close()" class="px-3 py-2 bg-gray-400 rounded ml-2">
            Cancel
        </button>
    </form>
</dialog>

</div>

<script>
function showDepositConfirm() {
    let amount = document.querySelector("div.bg-gray-800 input[name='amount']").value;
    let desc = document.querySelector("div.bg-gray-800 input[name='description']").value;

    if (!amount || amount <= 0) {
        alert("Enter deposit amount");
        return;
    }

    // Fill hidden fields
    document.getElementById("deposit_amount").value = amount;
    document.getElementById("deposit_description").value = desc;

    // Set modal text
    document.getElementById("depositText").innerText =
        `Deposit UGX ${Number(amount).toLocaleString()}?`;

    // Set form action
    document.getElementById("depositConfirmForm").action =
        "<?php echo e(route('admin.accounts.deposit', $account->id)); ?>";

    confirmDeposit.showModal();
}


function showWithdrawConfirm() {
    let amount = document.querySelector("div.bg-gray-800 input[name='withdraw_amount']").value;
    let desc = document.querySelector("div.bg-gray-800 input[name='withdraw_description']").value;

    if (!amount || amount <= 0) {
        alert("Enter withdrawal amount");
        return;
    }

    // Fill hidden fields
    document.getElementById("withdraw_amount").value = amount;
    document.getElementById("withdraw_description").value = desc;

    document.getElementById("withdrawText").innerText =
        `Withdraw UGX ${Number(amount).toLocaleString()}?`;

    document.getElementById("withdrawConfirmForm").action =
        "<?php echo e(route('admin.accounts.withdraw', $account->id)); ?>";

    confirmWithdraw.showModal();
}
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/accounts/show.blade.php ENDPATH**/ ?>