

    <!DOCTYPE html>
    <html>
    <head>
        <title>Receipt #<?php echo e($transaction->id); ?></title>

        <style>
            body {
                font-family: Arial, sans-serif;
                background: white;
                margin: 0;
                padding: 20px;
                color: #000;
            }

            .receipt-container {
                width: 700px;
                margin: auto;
                background: #fff;
                padding: 25px;
                border: 1px solid #ccc;
                border-radius: 6px;
            }

            h2, h3 {
                margin: 5px 0;
                text-align: center;
            }

            .section {
                margin-top: 20px;
            }

            table {
                width: 100%;
                margin-top: 10px;
                border-collapse: collapse;
            }

            td {
                padding: 8px 5px;
                border-bottom: 1px dashed #ccc;
            }

            .label {
                font-weight: bold;
                width: 35%;
            }

            .footer {
                text-align: center;
                margin-top: 30px;
                font-size: 12px;
                color: #444;
            }

            .print-btn {
                display: inline-block;
                background: #1a73e8;
                padding: 8px 16px;
                color: #fff;
                border-radius: 5px;
                text-decoration: none;
                margin-bottom: 20px;
            }

            @media print {
                .print-btn {
                    display: none;
                }
            }
        </style>
    </head>

    <body>

    <a href="#" onclick="window.print()" class="print-btn">Print Receipt</a>
    <a href="<?php echo e(route('admin.transactions.index')); ?>" onclick="window.print()" class="print-btn">Back </a>

    <div class="receipt-container">

        <h2><strong>HOSANNA SACCO</strong></h2>
        <h3>Transaction Receipt</h3>

        <div class="section">
            <table>
                <tr>
                    <td class="label">Receipt No:</td>
                    <td><?php echo e($transaction->id); ?></td>
                </tr>

                <tr>
                    <td class="label">Transaction Type:</td>
                    <td><?php echo e(ucfirst($transaction->type)); ?></td>
                </tr>

                <tr>
                    <td class="label">Date:</td>
                    <td><?php echo e($transaction->created_at->format('d M Y - h:i A')); ?></td>
                </tr>

                <tr>
                    <td class="label">Handled By:</td>
                    <td><?php echo e($transaction->admin->name ?? 'System'); ?></td>
                </tr>
            </table>
        </div>

        <div class="section">
            <h3>Account Information</h3>
            <table>
                <tr>
                    <td class="label">Account Number:</td>
                    <td><?php echo e($transaction->account->account_number); ?></td>
                </tr>

                <tr>
                    <td class="label">Member Name:</td>
                    <td><?php echo e($transaction->account->user->name); ?></td>
                </tr>
            </table>
        </div>

        <div class="section">
            <h3>Transaction Details</h3>

            <table>
                <tr>
                    <td class="label">Amount:</td>
                    <td><strong>UGX <?php echo e(number_format($transaction->amount)); ?></strong></td>
                </tr>

                <tr>
                    <td class="label">Balance Before:</td>
                    <td>UGX <?php echo e(number_format($transaction->balance_before)); ?></td>
                </tr>

                <tr>
                    <td class="label">Balance After:</td>
                    <td><strong>UGX <?php echo e(number_format($transaction->balance_after)); ?></strong></td>
                </tr>

                <?php if($transaction->description): ?>
                <tr>
                    <td class="label">Description:</td>
                    <td><?php echo e($transaction->description); ?></td>
                </tr>
                <?php endif; ?>
            </table>
        </div>

        <div class="footer">
            Thank you for using Hosanna SACCO. <br>
            Powered by Insight360
        </div>

    </div>

    <?php if(session('auto_print')): ?>
    <script>
        window.onload = function() {
            // give the browser a moment for fonts/styles, then open print dialog
            setTimeout(() => {
                window.print();
            }, 200);
        };
    </script>
    <?php endif; ?>


    </body>
    </html>
<?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/transactions/receipt.blade.php ENDPATH**/ ?>