<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Hossana Community Sacco</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-gray-50 flex flex-col min-h-screen">

    <!-- Hero Section -->
    <section class="flex flex-col justify-center items-center text-center bg-gradient-to-b from-blue-800 to-blue-600 text-white py-20 px-6">
        <div class="max-w-2xl">
            <!-- Icon -->
            <div class="flex justify-center mb-6">
                <div class="bg-white-700 p-4 rounded-2xl">
                    <!-- Hero Icon -->
                    
                <img src="<?php echo e(asset('images/hosanna-logo.png')); ?>" alt="Hosanna Sacco Logo" class="mx-auto w-32 h-auto mb-6">
          
                </div>
            </div>

            <!-- Heading -->
            <h1 class="text-4xl sm:text-5xl font-extrabold mb-4 leading-tight">
                Hosana Community  Development <br class="hidden sm:block" />  Sacco
            </h1>

            <!-- Subheading -->
            <p class="text-blue-100 mb-8 text-lg">
                Your trusted savings and credit cooperative partner. Build a secure financial future together.
            </p>

            <!-- Buttons -->
            <div class="flex flex-col sm:flex-row justify-center gap-4">
                <a href="<?php echo e(route('register')); ?>"
                    class="bg-white text-blue-700 font-semibold px-6 py-3 rounded-lg shadow hover:bg-gray-100 transition">
                    Get Started
                </a>
                <a href="<?php echo e(route('login')); ?>"
                    class="border border-blue-300 text-white font-semibold px-6 py-3 rounded-lg hover:bg-blue-700 transition">
                    Sign In
                </a>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="flex flex-col items-center py-16 px-6 bg-gray-50 text-center">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-10 max-w-5xl w-full">
            <!-- Feature 1 -->
            <div class="flex flex-col items-center">
                <div class="bg-blue-100 text-blue-600 p-4 rounded-xl mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8"
                            d="M3 17l6-6 4 4 8-8" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold mb-2">Track Your Savings</h3>
                <p class="text-gray-600 text-sm">Monitor your monthly and yearly savings with detailed analytics and insights.</p>
            </div>

            <!-- Feature 2 -->
            <div class="flex flex-col items-center">
                <div class="bg-green-100 text-green-600 p-4 rounded-xl mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8"
                            d="M17 20h5V4H2v16h5m10 0V10M7 20v-6m0 0H3m4 0h4" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold mb-2">Community Driven</h3>
                <p class="text-gray-600 text-sm">Join a community of savers working together towards financial independence.</p>
            </div>

            <!-- Feature 3 -->
            <div class="flex flex-col items-center">
                <div class="bg-emerald-100 text-emerald-600 p-4 rounded-xl mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8"
                            d="M12 11c0 1.104-.896 2-2 2s-2-.896-2-2 .896-2 2-2 2 .896 2 2z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8"
                            d="M12 11V7m0 8h0m0 0v4m0 0H8m4 0h4" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold mb-2">Secure & Reliable</h3>
                <p class="text-gray-600 text-sm">Your financial data is protected with enterprise-grade security measures.</p>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="py-6 text-center text-gray-500 text-sm bg-white border-t mt-auto">
        © <?php echo e(date('Y')); ?> Hosana  Comunity Sacco . All rights reserved.
    </footer>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\myproject\resources\views/landing.blade.php ENDPATH**/ ?>