

<?php $__env->startSection('content'); ?>
<div class="p-6 text-gray-100">

    <div class="flex justify-between mb-4">
        <h1 class="text-2xl font-bold">Income Records</h1>
        <a href="<?php echo e(route('admin.incomes.create')); ?>"
           class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">+ Add Income</a>
    </div>

    <!-- ================= FILTER BAR ================= -->
    <form method="GET" action="<?php echo e(route('admin.incomes.index')); ?>" class="bg-gray-800 p-4 rounded mb-6">

        <div class="grid grid-cols-1 md:grid-cols-6 gap-4">

            <!-- Search -->
            <div class="md:col-span-2">
                <input type="text" name="search" placeholder="Search description, amount, member..."
                       value="<?php echo e(request('search')); ?>"
                       class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
            </div>

            <!-- Income Type -->
            <div>
                <select name="income_type_id" class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
                    <option value="">All Types</option>
                    <?php $__currentLoopData = $incomeTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($type->id); ?>" 
                            <?php echo e(request('income_type_id') == $type->id ? 'selected' : ''); ?>>
                            <?php echo e($type->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!-- Payment Method -->
            <div>
                <select name="payment_method" class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
                    <option value="">All Payments</option>
                    <option value="cash"         <?php echo e(request('payment_method')=='cash' ? 'selected' : ''); ?>>Cash</option>
                    <option value="mobile_money" <?php echo e(request('payment_method')=='mobile_money' ? 'selected' : ''); ?>>Mobile Money</option>
                    <option value="bank"         <?php echo e(request('payment_method')=='bank' ? 'selected' : ''); ?>>Bank</option>
                </select>
            </div>

            <!-- Member -->
            <div>
                <select name="member_id" class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
                    <option value="">All Members</option>
                    <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($mem->id); ?>"
                            <?php echo e(request('member_id') == $mem->id ? 'selected' : ''); ?>>
                            <?php echo e($mem->name); ?> (<?php echo e($mem->member_id); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!-- Date From -->
            <div>
                <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>"
                       class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
            </div>

            <!-- Date To -->
            <div>
                <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>"
                       class="w-full px-3 py-2 bg-gray-700 rounded border border-gray-600">
            </div>
        </div>

        <!-- Buttons -->
        <div class="flex justify-end mt-4 gap-3">
            <a href="<?php echo e(route('admin.incomes.index')); ?>"
               class="px-4 py-2 bg-gray-600 rounded hover:bg-gray-500">Reset</a>

            <button class="px-4 py-2 bg-blue-600 rounded hover:bg-blue-700">Apply</button>
        </div>

    </form>

    <div class="flex gap-3 mb-4">
    <a href="<?php echo e(route('admin.incomes.export.csv', request()->query())); ?>"
       class="bg-green-600 px-4 py-2 rounded hover:bg-green-700">
        📄 Export CSV
    </a>

    <a href="<?php echo e(route('admin.incomes.export.pdf', request()->query())); ?>"
       class="bg-red-600 px-4 py-2 rounded hover:bg-red-700">
        🧾 Export PDF
    </a>
</div>

    <!-- ================= END FILTER BAR ================= -->



    <!-- ================= TABLE ================= -->
    <table class="w-full bg-gray-800 text-left rounded overflow-hidden">
        <thead class="bg-gray-700 text-gray-300">
            <tr>
                <th class="p-3">Receipt</th>
                <th class="p-3">Type</th>
                <th class="p-3">Member</th>
                <th class="p-3">Amount</th>
                <th class="p-3">Payment</th>
                <th class="p-3">Date</th>
                <th class="p-3">Recorded By</th>
                <th class="p-3">Action</th>
            </tr>
        </thead>

        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $incomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr class="border-b border-gray-700">
                <td class="p-3"><?php echo e($inc->receipt_no); ?></td>
                <td class="p-3"><?php echo e($inc->type->name); ?></td>
                <td class="p-3"><?php echo e($inc->member->name ?? '—'); ?></td>
                <td class="p-3 text-green-400">UGX <?php echo e(number_format($inc->amount)); ?></td>
                <td class="p-3"><?php echo e(ucfirst(str_replace('_', ' ', $inc->payment_method))); ?></td>
                <td class="p-3"><?php echo e($inc->income_date); ?></td>
                <td class="p-3"><?php echo e($inc->admin->name); ?></td>
                <td class="p-3">
                    <a href="<?php echo e(route('admin.incomes.edit', $inc)); ?>" 
                       class="text-blue-400 hover:underline">Edit</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="8" class="text-center p-5 text-gray-400">
                    No income records found.
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="mt-4">
        <?php echo e($incomes->links()); ?>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/incomes/index.blade.php ENDPATH**/ ?>