

<?php $__env->startSection('content'); ?>
<h1 class="text-2xl font-bold mb-4">Policies</h1>

<a href="<?php echo e(route('admin.policies.create')); ?>"
   class="bg-blue-600 px-4 py-2 text-white rounded mb-4 inline-block">
    Create Policy
</a>

<table class="w-full bg-gray-800 text-left text-gray-200 rounded">
    <tr class="bg-gray-700">
        <th class="p-2">Title</th>
        <th class="p-2">Version</th>
        <th class="p-2">Active</th>
        <th class="p-2">Actions</th>
    </tr>

    <?php $__currentLoopData = $policies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr class="border-b border-gray-700">
            <td class="p-2"><?php echo e($policy->title); ?></td>
            <td class="p-2"><?php echo e($policy->version); ?></td>
            <td class="p-2"><?php echo e($policy->is_active ? 'Yes' : 'No'); ?></td>
            <td class="p-2">
                <a href="<?php echo e(route('admin.policies.edit', $policy)); ?>" class="text-blue-400 mr-2">Edit</a>

                <form action="<?php echo e(route('admin.policies.destroy', $policy)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button onclick="return confirm('Delete this policy?')" class="text-red-400">Delete</button>
                </form>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/policies/index.blade.php ENDPATH**/ ?>