

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto bg-gray-800 p-8 rounded-lg shadow-lg">

    <div class="flex items-center justify-between mb-6">
        <h1 class="text-3xl font-bold text-white">Edit Policy</h1>

        <div class="space-x-2">
            <a href="<?php echo e(route('admin.policies.index')); ?>"
               class="text-sm px-3 py-2 rounded bg-gray-700 hover:bg-gray-600 text-gray-200">
               ← Back to list
            </a>
        </div>
    </div>

    <form action="<?php echo e(route('admin.policies.update', $policy)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        
        <div class="mb-5">
            <label class="text-gray-300 font-semibold block mb-2">Title</label>
            <input type="text"
                   name="title"
                   value="<?php echo e(old('title', $policy->title)); ?>"
                   class="w-full bg-gray-700 text-white border border-gray-600 rounded-lg p-3 focus:border-blue-500 focus:ring focus:ring-blue-500/30"
                   placeholder="Enter policy title"
                   required>
        </div>

        
        <div class="mb-5">
            <label class="text-gray-300 font-semibold block mb-2">Description</label>
            <input type="text"
                   name="description"
                   value="<?php echo e(old('description', $policy->description)); ?>"
                   class="w-full bg-gray-700 text-white border border-gray-600 rounded-lg p-3 focus:border-blue-500 focus:ring focus:ring-blue-500/30"
                   placeholder="Short description">
        </div>

        
        <div class="mb-5">
            <label class="text-gray-300 font-semibold block mb-2">Content</label>
            <textarea name="content"
                      rows="10"
                      class="w-full bg-gray-700 text-white border border-gray-600 rounded-lg p-3 focus:border-blue-500 focus:ring focus:ring-blue-500/30"
                      placeholder="Full policy text..."
                      required><?php echo e(old('content', $policy->content)); ?></textarea>
        </div>

        
        <div class="mb-5">
            <label class="text-gray-300 font-semibold block mb-2">Version</label>
            <input type="text"
                   name="version"
                   value="<?php echo e(old('version', $policy->version)); ?>"
                   class="w-full bg-gray-700 text-white border border-gray-600 rounded-lg p-3 focus:border-blue-500 focus:ring focus:ring-blue-500/30">
        </div>

        
        <div class="flex items-center mb-6">
            <input type="checkbox"
                   name="is_active"
                   value="1"
                   <?php echo e(old('is_active', $policy->is_active) ? 'checked' : ''); ?>

                   class="h-5 w-5 text-blue-500 rounded border-gray-500 bg-gray-700 focus:ring-blue-600">
            <label class="ml-3 text-gray-300 font-medium">Active?</label>
        </div>

        <div class="flex items-center space-x-3">
            <button type="submit"
                    class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 focus:ring focus:ring-blue-500/40">
                Update Policy
            </button>

            
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/policies/edit.blade.php ENDPATH**/ ?>