

<?php $__env->startSection('content'); ?>
<div class="p-6 space-y-6">

    <h2 class="text-2xl font-semibold text-gray-100">Loan Applications</h2>

    <!-- Filter Box -->
    <div class="bg-gray-800 p-4 rounded shadow">
        <form method="GET" class="mb-4 flex gap-2">
            <select name="status" class="px-3 py-2 bg-gray-700 rounded text-gray-200">
                <option value="">All statuses</option>
                <option value="pending"   <?php echo e(request('status')=='pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="approved"  <?php echo e(request('status')=='approved' ? 'selected' : ''); ?>>Approved</option>
                <option value="disbursed" <?php echo e(request('status')=='disbursed' ? 'selected' : ''); ?>>Disbursed</option>
                <option value="rejected"  <?php echo e(request('status')=='rejected' ? 'selected' : ''); ?>>Rejected</option>
                <option value="closed"    <?php echo e(request('status')=='closed' ? 'selected' : ''); ?>>Closed</option>
            </select>

            <button class="px-3 py-2 bg-blue-600 rounded text-white">Filter</button>
        </form>

        <!-- Table -->
        <table class="w-full text-left text-gray-200">
            <thead class="text-gray-400 bg-gray-700">
                <tr>
                    <th class="p-2">Date</th>
                    <th>Member</th>
                    <th>Loan Type</th>
                    <th>Principal</th>
                    <th>Total Payable</th>
                    <th>Status</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-t border-gray-700 hover:bg-gray-700">

                    <td class="p-2">
                        <?php echo e($loan->created_at->format('Y-m-d')); ?>

                    </td>

                    <td class="p-2">
                        <?php echo e($loan->user->name ?? 'Unknown'); ?> <br>
                        <span class="text-xs text-gray-400"><?php echo e($loan->user->member_id ?? ''); ?></span>
                    </td>

                    <td class="p-2">
                        <?php echo e($loan->loanType->name ?? 'N/A'); ?>

                    </td>

                    <td class="p-2">
                        UGX <?php echo e(number_format($loan->principal)); ?>

                    </td>

                    <td class="p-2">
                        UGX <?php echo e(number_format($loan->total_payable)); ?>

                    </td>

                    <td class="p-2">
                        <span class="px-2 py-1 rounded text-xs 
                            <?php if($loan->status=='pending'): ?> bg-yellow-600 
                            <?php elseif($loan->status=='approved'): ?> bg-blue-600 
                            <?php elseif($loan->status=='disbursed'): ?> bg-purple-600 
                            <?php elseif($loan->status=='rejected'): ?> bg-red-600 
                            <?php elseif($loan->status=='closed'): ?> bg-green-600 
                            <?php else: ?> bg-gray-600 <?php endif; ?>">
                            <?php echo e(ucfirst($loan->status)); ?>

                        </span>
                    </td>

                    <td class="p-2 text-right space-x-2">

                        <!-- View Button -->
                        <a href="<?php echo e(route('admin.loans.show', $loan->id)); ?>"
                           class="text-blue-400 hover:underline">
                           View
                        </a>

                        <!-- Approve -->
                        <?php if($loan->status === 'pending'): ?>
                        <form action="<?php echo e(route('admin.loans.approve', $loan->id)); ?>" 
                              method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button class="text-green-400 hover:underline">Approve</button>
                        </form>

                        <!-- Reject -->
                        <form action="<?php echo e(route('admin.loans.reject', $loan->id)); ?>" 
                              method="POST" class="inline ml-2">
                            <?php echo csrf_field(); ?>
                            <button class="text-red-400 hover:underline">Reject</button>
                        </form>
                        <?php endif; ?>

                        <!-- Disburse -->
                        <?php if($loan->status === 'approved'): ?>
                        <form action="<?php echo e(route('admin.loans.disburse', $loan->id)); ?>" 
                              method="POST" class="inline ml-2">
                            <?php echo csrf_field(); ?>
                            <button class="text-purple-400 hover:underline">Disburse</button>
                        </form>
                        <?php endif; ?>

                    </td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="py-6 text-center text-gray-400">No loans found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="mt-4">
            <?php echo e($loans->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/loans/index.blade.php ENDPATH**/ ?>