<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #444; padding: 6px; text-align: left; }
        th { background: #ddd; }
    </style>
</head>
<body>

<h2>Income Report</h2>
<p>Generated: <?php echo e($generated_at); ?></p>

<table>
    <thead>
        <tr>
            <th>Receipt</th>
            <th>Type</th>
            <th>Member</th>
            <th>Amount</th>
            <th>Payment</th>
            <th>Date</th>
            <th>Recorded By</th>
        </tr>
    </thead>

    <tbody>
        <?php $__currentLoopData = $incomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($inc->receipt_no); ?></td>
            <td><?php echo e($inc->type->name); ?></td>
            <td><?php echo e($inc->member->name ?? '—'); ?></td>
            <td>UGX <?php echo e(number_format($inc->amount)); ?></td>
            <td><?php echo e(ucfirst($inc->payment_method)); ?></td>
            <td><?php echo e($inc->income_date); ?></td>
            <td><?php echo e($inc->admin->name); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/incomes/pdf.blade.php ENDPATH**/ ?>