

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-2xl font-bold text-white">Groups</h2>
        <a href="<?php echo e(route('admin.groups.create')); ?>" class="px-4 py-2 bg-indigo-600 rounded text-white">New Group</a>
    </div>

    <?php if(session('success')): ?> <div class="mb-3 p-3 bg-green-600 text-white"><?php echo e(session('success')); ?></div> <?php endif; ?>
    <?php if(session('error')): ?> <div class="mb-3 p-3 bg-red-600 text-white"><?php echo e(session('error')); ?></div> <?php endif; ?>

    <div class="bg-gray-800 rounded p-4">
        <table class="w-full text-left text-gray-200">
            <thead class="text-gray-400">
                <tr>
                    <th class="py-2">Name</th>
                    <th>Active Members</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-t border-gray-700">
                        <td class="py-2"><?php echo e($g->name); ?></td>
                        <td><?php echo e($g->active_members_count ?? 0); ?></td>
                        <td><?php echo e(ucfirst($g->status)); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.groups.show', $g->id)); ?>" class="text-blue-400">View</a>
                            <a href="<?php echo e(route('admin.groups.edit', $g->id)); ?>" class="ml-3 text-yellow-400">Edit</a>
                            <form action="<?php echo e(route('admin.groups.destroy', $g->id)); ?>" method="POST" class="inline-block ml-3" onsubmit="return confirm('Delete group?');">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button class="text-red-400">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="4" class="py-4 text-gray-400">No groups yet.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="mt-4">
            <?php echo e($groups->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/groups/index.blade.php ENDPATH**/ ?>