

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-2xl font-bold text-white">Loan Types</h2>
        <a href="<?php echo e(route('admin.loan_types.create')); ?>" class="px-4 py-2 bg-indigo-600 rounded text-white">New Loan Type</a>
    </div>

    <?php if(session('success')): ?> <div class="mb-3 p-3 bg-green-600 text-white"><?php echo e(session('success')); ?></div> <?php endif; ?>

    <div class="bg-gray-800 p-4 rounded">
        <table class="w-full text-left text-gray-200">
            <thead class="text-gray-400">
                <tr>
                    <th>Name</th>
                    <th>Interest %</th>
                    <th>Duration (m)</th>
                    <th>Group?</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-t border-gray-700">
                    <td class="py-2"><?php echo e($t->name); ?></td>
                    <td><?php echo e($t->interest_rate); ?></td>
                    <td><?php echo e($t->duration_months); ?></td>
                    <td><?php echo e($t->is_group_loan ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e(ucfirst($t->status)); ?></td>
                    <td>
                        <a href="<?php echo e(route('admin.loan_types.edit', $t->id)); ?>" class="text-yellow-400">Edit</a>
                        <form action="<?php echo e(route('admin.loan_types.destroy', $t->id)); ?>" method="POST" class="inline ml-2" onsubmit="return confirm('Delete?');">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="text-red-400">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="6" class="py-4 text-gray-400">No loan types yet.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="mt-4"><?php echo e($types->links()); ?></div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/loan_types/index.blade.php ENDPATH**/ ?>