

<?php $__env->startSection('content'); ?>
<div class="p-6 max-w-2xl mx-auto">

    <h2 class="text-2xl font-semibold text-gray-100 mb-4">Add User</h2>

    
    <?php if(session('success')): ?>
        <div class="bg-green-700 text-white p-4 rounded-lg shadow mb-6">
            <p class="font-semibold"><?php echo e(session('success')); ?></p>

            <?php if(session('temp_password')): ?>
                <div class="mt-3 bg-gray-900 p-3 rounded border border-gray-700">
                    <p class="text-sm">A temporary password has been generated for:</p>
                    <p class="text-blue-300 font-semibold"><?php echo e(session('temp_user_email')); ?></p>

                    <p class="mt-2 text-sm">
                        <strong>Temp Password:</strong>
                        <span class="ml-2 font-mono text-yellow-300 text-lg">
                            <?php echo e(session('temp_password')); ?>

                        </span>
                    </p>

                    <p class="text-xs text-gray-400 mt-2">
                        Share this password with the user. They should change it after logging in.
                    </p>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    
    <form action="<?php echo e(route('users.store')); ?>" method="POST" enctype="multipart/form-data"
          class="space-y-4 bg-gray-800 p-6 rounded-lg shadow">
        <?php echo csrf_field(); ?>

        <div>
            <label class="block text-sm text-gray-300">Name</label>
            <input type="text" name="name"
                class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white" required>
        </div>

        <div>
            <label class="block text-sm text-gray-300">Email</label>
            <input type="email" name="email"
                class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white" required>
        </div>

        <div class="grid grid-cols-2 gap-4">

            <div>
                <label class="block text-sm text-gray-300">Phone</label>
                <input type="text" name="phone"
                    class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
            </div>

            <div>
                <label class="block text-sm text-gray-300">Profile Photo</label>
                <input type="file" name="photo"
                    class="w-full p-2 rounded bg-gray-700 border border-gray-600 text-white">
            </div>

            <div>
                <label class="block text-sm text-gray-300">National ID</label>
                <input type="text" name="national_id"
                    class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
            </div>
        </div>

        <div>
            <label class="block text-sm text-gray-300">Address</label>
            <input type="text" name="address"
                   class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
        </div>

        <div>
            <label class="block text-sm text-gray-300">Role</label>
            <select name="role"
                class="w-full p-2 rounded bg-gray-900 border border-gray-700 text-white">
                <option value="admin">Admin</option>
    <option value="member">Member</option>
    <option value="loan_officer">Loan Officer</option>
    <option value="accountant">Accountant / Teller</option>
            </select>
        </div>

        <div class="pt-4 flex items-center">
            <button class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded">
                Save User
            </button>
            <a href="<?php echo e(route('users.index')); ?>"
               class="text-gray-400 ml-4 hover:text-gray-200">
                Cancel
            </a>
        </div>

    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/users/create.blade.php ENDPATH**/ ?>