

<?php $__env->startSection('content'); ?>
<div class="p-6 text-gray-100">

    <div class="flex justify-between mb-4">
        <h1 class="text-2xl font-bold">Expenses</h1>
        <a href="<?php echo e(route('admin.expenses.create')); ?>"
           class="bg-blue-600 px-4 py-2 rounded hover:bg-blue-700">+ Add Expense</a>
    </div>

    <table class="w-full bg-gray-800 rounded overflow-hidden">
        <thead class="bg-gray-700 text-gray-300">
            <tr>
                <th class="p-3 text-left">Date</th>
                <th class="p-3 text-left">Category</th>
                <th class="p-3 text-left">Amount</th>
                <th class="p-3 text-left">Recorded By</th>
                <th class="p-3 text-left">Action</th>
            </tr>
        </thead>

        <tbody>
            <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-b border-gray-700">
                <td class="p-3"><?php echo e($expense->expense_date); ?></td>
                <td class="p-3"><?php echo e($expense->category); ?></td>
                <td class="p-3">UGX <?php echo e(number_format($expense->amount, 0)); ?></td>
                <td class="p-3"><?php echo e($expense->user->name); ?></td>
                <td class="p-3">
                    <a href="<?php echo e(route('admin.expenses.edit', $expense)); ?>"
                       class="text-blue-400 hover:text-blue-200">Edit</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="mt-4">
        <?php echo e($expenses->links()); ?>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/expenses/index.blade.php ENDPATH**/ ?>