<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Member Panel - Hosanna Sacco</title>
    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
</head>

<body class="bg-gray-900 text-gray-200 flex min-h-screen">

    <!-- Sidebar -->
    <aside class="w-64 bg-gray-800 text-white flex flex-col">
        <div class="p-6 text-center border-b border-gray-600">
            <h1 class="text-xl font-bold">HOSANNA SACCO</h1>
            <p class="text-sm">Member Panel</p>
        </div>

        <nav class="flex-1 p-4 space-y-2">

            <a href="<?php echo e(route('member.dashboard')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                🏠 Dashboard
            </a>

            <p class="text-xs uppercase text-blue-300 mt-4">Loans</p>

            <a href="<?php echo e(route('member.loans.apply')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                📝 Apply Loan
            </a>

            <a href="<?php echo e(route('member.loans.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                📚 My Loans
            </a>

            <p class="text-xs uppercase text-blue-300 mt-4">Policies & Terms</p>

            <a href="<?php echo e(route('member.policies.index')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                Policies (Terms and Conditions)
            </a>

            <p class="text-xs uppercase text-blue-300 mt-4">Statements</p>

            <a href="<?php echo e(route('member.statement')); ?>" class="block py-2 px-3 rounded hover:bg-blue-700">
                Member statement
            </a>

        </nav>

        <div class="p-4 border-t border-blue-700">
            <form action="<?php echo e(route('logout')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button class="w-full text-left py-2 px-3 rounded hover:bg-blue-700">
                    🚪 Logout
                </button>
            </form>
        </div>

    </aside>

    <main class="flex-1 p-6">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\myproject\resources\views/layouts/member.blade.php ENDPATH**/ ?>