

<?php $__env->startSection('content'); ?>

<div class="p-6 space-y-8">

    
    <div>
        <h2 class="text-3xl font-bold text-gray-100">Loan Officer Dashboard</h2>
        <p class="text-gray-400 mt-1">
            Welcome, <?php echo e(auth()->user()->name); ?>. Review and take action on loan applications.
        </p>
    </div>

    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

        <div class="bg-gray-800 p-4 rounded shadow border-l-4 border-yellow-500">
            <h3 class="text-gray-400 text-sm">Pending Loans</h3>
            <p class="text-2xl font-bold text-yellow-400"><?php echo e($stats['pending']); ?></p>
        </div>

        <div class="bg-gray-800 p-4 rounded shadow border-l-4 border-blue-500">
            <h3 class="text-gray-400 text-sm">Approved & Awaiting Disbursement</h3>
            <p class="text-2xl font-bold text-blue-400"><?php echo e($stats['approved']); ?></p>
        </div>

        <div class="bg-gray-800 p-4 rounded shadow border-l-4 border-purple-500">
            <h3 class="text-gray-400 text-sm">Active Loans</h3>
            <p class="text-2xl font-bold text-purple-400"><?php echo e($stats['active']); ?></p>
        </div>

    </div>

    
    <div class="bg-gray-800 p-6 rounded shadow">
        <h3 class="text-xl font-semibold text-gray-100 mb-4">Loans Needing Action</h3>

        <table class="w-full text-left text-gray-200">
            <thead class="bg-gray-700 text-gray-400">
                <tr>
                    <th class="p-2">Member</th>
                    <th>Type</th>
                    <th>Principal</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th class="text-right">Actions</th>
                </tr>
            </thead>

            <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-t border-gray-700 hover:bg-gray-700">

                    <td class="p-2">
                        <?php echo e($loan->user->name); ?><br>
                        <span class="text-xs text-gray-400"><?php echo e($loan->user->member_id); ?></span>
                    </td>

                    <td class="p-2">
                        <?php echo e($loan->loanType->name); ?>

                    </td>

                    <td class="p-2">
                        UGX <?php echo e(number_format($loan->principal)); ?>

                    </td>

                    <td class="p-2">
                        <span class="px-2 py-1 text-xs rounded 
                            <?php if($loan->status=='pending'): ?> bg-yellow-600 
                            <?php elseif($loan->status=='approved'): ?> bg-blue-600 
                            <?php elseif($loan->status=='active'): ?> bg-purple-600 
                            <?php else: ?> bg-gray-600 <?php endif; ?>">
                            <?php echo e(ucfirst($loan->status)); ?>

                        </span>
                    </td>

                    <td class="p-2">
                        <?php echo e($loan->created_at->format('Y-m-d')); ?>

                    </td>

                    <td class="p-2 text-right">
                        <a href="<?php echo e(route('loan_officer.loans.show', $loan->id)); ?>"
                           class="text-blue-400 hover:underline">
                            View
                        </a>
                    </td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="py-6 text-center text-gray-500">
                        No loans to review at the moment.
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.loan_officer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/loan_officer/loans/index.blade.php ENDPATH**/ ?>