

<?php $__env->startSection('content'); ?>

<div class="p-6 text-gray-200">

    <!-- Page Title -->
    <h1 class="text-3xl font-bold mb-6">
        Loan Details — #<?php echo e($loan->id); ?>

        <span class="ml-3 px-3 py-1 rounded text-sm 
            <?php if($loan->status == 'pending'): ?> bg-yellow-600
            <?php elseif($loan->status == 'approved'): ?> bg-blue-600
            <?php elseif($loan->status == 'disbursed'): ?> bg-purple-600
            <?php elseif($loan->status == 'closed'): ?> bg-green-600
            <?php elseif($loan->status == 'rejected'): ?> bg-red-600
            <?php endif; ?>">
            <?php echo e(ucfirst($loan->status)); ?>

        </span>
    </h1>

    <!-- Grid Layout -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

        <!-- Loan Summary -->
        <div class="bg-gray-800 p-5 rounded shadow col-span-2">
            <h2 class="text-xl font-bold text-blue-300 mb-4">Loan Summary</h2>

            <div class="grid grid-cols-2 gap-4 text-gray-300">
                <p><strong>Loan Type:</strong><br><?php echo e($loan->loanType->name); ?></p>

                <p><strong>Principal:</strong><br>
                    UGX <?php echo e(number_format($loan->principal)); ?>

                </p>

                <p><strong>Interest Rate:</strong><br><?php echo e($loan->interest_rate); ?>%</p>

                <p><strong>Total Payable:</strong><br>
                    UGX <?php echo e(number_format($loan->total_payable)); ?>

                </p>

                <p><strong>Balance Remaining:</strong><br>
                    <span class="text-yellow-300 font-bold">
                        UGX <?php echo e(number_format($loan->balance)); ?>

                    </span>
                </p>

                <p><strong>Group Loan:</strong><br>
                    <?php echo e($loan->group ? $loan->group->name : 'No'); ?>

                </p>

                <p><strong>Applied On:</strong><br>
                    <?php echo e($loan->created_at->format('d M, Y')); ?>

                </p>

                <?php if($loan->approved_at): ?>
                <p><strong>Approved On:</strong><br>
                    <?php echo e(\Carbon\Carbon::parse($loan->approved_at)->format('d M, Y')); ?>

                </p>
                <?php endif; ?>

                <?php if($loan->disbursed_at): ?>
                <p><strong>Disbursed On:</strong><br>
                    <?php echo e(\Carbon\Carbon::parse($loan->disbursed_at)->format('d M, Y')); ?>

                </p>
                <?php endif; ?>
            </div>

            <?php if($loan->admin_notes): ?>
            <div class="mt-5 bg-gray-700 p-3 rounded">
                <h3 class="font-semibold text-gray-300">Admin Notes</h3>
                <p class="text-sm text-gray-400"><?php echo e($loan->admin_notes); ?></p>
            </div>
            <?php endif; ?>
        </div>

        <!-- Member Profile -->
        <div class="bg-gray-800 p-5 rounded shadow">
            <h2 class="text-xl font-bold text-green-300 mb-4">Member Profile</h2>

            <div class="flex items-center gap-4">
                <img src="<?php echo e($loan->user->photo ? asset('storage/photos/' . $loan->user->photo) : 'https://ui-avatars.com/api/?name=' . $loan->user->name); ?>"
                     class="w-16 h-16 rounded-full border border-gray-600">
                <div>
                    <p class="font-bold text-lg"><?php echo e($loan->user->name); ?></p>
                    <p class="text-gray-400 text-sm"><?php echo e($loan->user->email); ?></p>
                    <p class="text-gray-400 text-sm">ID: <?php echo e($loan->user->member_id); ?></p>
                </div>
            </div>

            <div class="mt-4 text-gray-300 text-sm">
                <p><strong>Phone:</strong> <?php echo e($loan->user->phone); ?></p>
                <p><strong>Address:</strong> <?php echo e($loan->user->address); ?></p>
                <p><strong>National ID:</strong> <?php echo e($loan->user->national_id); ?></p>
            </div>


            
        </div>

        

    </div>

    <!-- Admin Actions -->
    <div class="bg-gray-800 rounded p-5 mt-8 shadow">
        <h2 class="text-xl font-bold text-purple-300 mb-4">Admin Actions</h2>

        <div class="flex flex-wrap gap-3">

            <?php if($loan->status === 'pending'): ?>
                <form action="<?php echo e(route('admin.loans.approve', $loan->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 rounded text-white">
                        Approve Loan
                    </button>
                </form>

                <form action="<?php echo e(route('admin.loans.reject', $loan->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button class="px-4 py-2 bg-red-600 hover:bg-red-700 rounded text-white">
                        Reject Loan
                    </button>
                </form>
            <?php endif; ?>

            <?php if($loan->status === 'approved'): ?>
                <form action="<?php echo e(route('admin.loans.disburse', $loan->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button class="px-4 py-2 bg-purple-600 hover:bg-purple-700 rounded text-white">
                        Disburse Loan
                    </button>
                </form>
            <?php endif; ?>

           <?php if($loan->balance > 0.0 && in_array($loan->status, ['disbursed', 'active'])): ?>
    <button onclick="document.getElementById('repayModal').showModal()"
            class="px-4 py-2 bg-green-600 hover:bg-green-700 rounded text-white">
        Record Repayment
    </button>
<?php endif; ?>


<?php if($loan->balance < 0.0000 && $loan->status !== 'closed'): ?>
<form action="<?php echo e(route('admin.loans.close', $loan->id)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <button class="px-4 py-2 bg-green-700 hover:bg-green-800 rounded text-white">
        Close Loan
    </button>
</form>
<?php endif; ?>




        </div>
    </div>

    <!-- Repayment Schedule -->
    <div class="bg-gray-800 rounded p-5 mt-8 shadow">
        <h2 class="text-xl font-bold text-yellow-300 mb-4">Repayment History</h2>

        <table class="w-full text-left text-gray-300">
            <thead class="bg-gray-700">
                <tr>
                    <th class="p-2">Date</th>
                    <th class="p-2">Amount</th>
                    <th class="p-2">Admin</th>
                    <th class="p-2">Notes</th>
                </tr>
            </thead>
          <tbody>
<?php $__empty_1 = true; $__currentLoopData = $repayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<tr class="border-b border-gray-700">
    <td class="p-2"><?php echo e($r->created_at->format('d M Y')); ?></td>
    <td class="p-2 text-green-400">UGX <?php echo e(number_format($r->amount)); ?></td>
    <td class="p-2"><?php echo e($r->admin ? $r->admin->name : 'System'); ?></td>
    <td class="p-2"><?php echo e($r->notes ?? '-'); ?></td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
    <td colspan="4" class="p-3 text-center text-gray-400">No repayments recorded.</td>
</tr>
<?php endif; ?>
</tbody>

        </table>
    </div>

</div>


<!-- Repayment Modal -->
<dialog id="repayModal" class="bg-gray-800 p-6 rounded shadow-lg text-gray-200 w-96">
    <h3 class="text-xl font-bold mb-3">Record Repayment</h3>

    <form action="<?php echo e(route('admin.loans.repay', $loan->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <label class="block text-gray-300">Amount</label>
        <input type="number" name="amount" class="w-full p-2 mb-3 bg-gray-700 rounded">

        <label class="block text-gray-300">Notes</label>
        <textarea name="notes" class="w-full p-2 bg-gray-700 rounded"></textarea>

        <div class="mt-4 flex justify-end gap-2">
            <button type="button" onclick="repayModal.close()" class="px-3 py-1 bg-gray-600 rounded">
                Cancel
            </button>
            <button class="px-3 py-1 bg-green-600 rounded">Save</button>
        </div>
    </form>
</dialog>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/loans/show.blade.php ENDPATH**/ ?>