

<?php $__env->startSection('content'); ?>

<h1 class="text-3xl font-bold text-white mb-6">Financial Insights</h1>

<div class="grid grid-cols-1 md:grid-cols-2 gap-6">

    <!-- Savings Trend -->
    <div class="bg-gray-800 p-6 rounded-lg shadow">
        <h2 class="text-xl font-semibold text-blue-300 mb-3">Savings Trend (Monthly)</h2>
        <canvas id="savingsTrendChart"></canvas>
    </div>

    <!-- Loan Balance Curve -->
    <div class="bg-gray-800 p-6 rounded-lg shadow">
        <h2 class="text-xl font-semibold text-purple-300 mb-3">Loan Balance Decline Curve</h2>
        <?php if($loanSchedule->isEmpty()): ?>
            <p class="text-gray-400">You have no loan schedule available.</p>
        <?php else: ?>
            <canvas id="loanBalanceChart"></canvas>
        <?php endif; ?>
    </div>

 


    <!-- Deposits vs Withdrawals -->
<div class="bg-gray-800 p-6 rounded-lg shadow md:col-span-2">
    <h2 class="text-xl font-semibold text-yellow-300 mb-3">Deposits vs Withdrawals</h2>

    <div class="flex justify-center">
        <div class="w-[300px] h-[300px]">
            <canvas id="pieChart"></canvas>
        </div>
    </div>
</div>


</div>


<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    /* ============================================================
     * 1. Savings Trend Chart (Deposits & Withdrawals)
     * ============================================================ */
    const savingsMonths = <?php echo json_encode($monthlyDeposits->keys(), 15, 512) ?>;
    const depositsData = <?php echo json_encode($monthlyDeposits->values(), 15, 512) ?>;
    const withdrawalsData = <?php echo json_encode($monthlyWithdrawals->values(), 15, 512) ?>;

    new Chart(document.getElementById('savingsTrendChart'), {
        type: 'line',
        data: {
            labels: savingsMonths,
            datasets: [
                {
                    label: 'Deposits',
                    data: depositsData,
                    borderWidth: 2
                },
                {
                    label: 'Withdrawals',
                    data: withdrawalsData,
                    borderWidth: 2
                }
            ]
        }
    });


    /* ============================================================
     * 2. Loan Balance Decline Curve
     * ============================================================ */
    <?php if($loanSchedule->isNotEmpty()): ?>
        const loanPeriods = <?php echo json_encode($loanSchedule->pluck('period'), 15, 512) ?>;
        const loanBalances = <?php echo json_encode($loanSchedule->pluck('balance'), 15, 512) ?>;

        new Chart(document.getElementById('loanBalanceChart'), {
            type: 'line',
            data: {
                labels: loanPeriods,
                datasets: [{
                    label: 'Remaining Loan Balance',
                    data: loanBalances,
                    borderWidth: 2
                }]
            }
        });
    <?php endif; ?>


    /* ============================================================
     * 3. Deposits vs Withdrawals Pie Chart
     * ============================================================ */
    const totalDeposits = <?php echo e($totalDeposits); ?>;
    const totalWithdrawals = <?php echo e($totalWithdrawals); ?>;

    new Chart(document.getElementById('pieChart'), {
        type: 'pie',
        data: {
            labels: ['Deposits', 'Withdrawals'],
            datasets: [{
                data: [totalDeposits, totalWithdrawals],
                borderWidth: 1
            }]
        }
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/member/insights.blade.php ENDPATH**/ ?>