

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-6 py-6">

   <div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-white">Accounts</h1>

    <div class="flex gap-3">
        <a href="<?php echo e(route('admin.accounts.export.csv')); ?>"
           class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded shadow">
            ⬇ Export CSV
        </a>
        <a href="<?php echo e(route('admin.accounts.export.excel', request()->query())); ?>"
   class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded shadow">
    ⬇ Export Excel
</a>


        <a href="<?php echo e(route('admin.accounts.create')); ?>"
           class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded shadow">
            + Add Account
        </a>
    </div>
</div>


    <!-- Filter + Search Bar -->
    <form method="GET" action="<?php echo e(route('admin.accounts.index')); ?>"
          class="flex flex-wrap gap-4 bg-gray-800 p-4 rounded-lg mb-6">

        <!-- Search -->
        <div class="relative flex-1 min-w-[250px]">
            <span class="absolute inset-y-0 left-3 flex items-center text-gray-400">
                🔍
            </span>
            <input type="text"
                   name="search"
                   value="<?php echo e(request('search')); ?>"
                   placeholder="Search accounts or members..."
                   class="w-full pl-10 pr-3 py-2 bg-gray-700 text-white rounded focus:ring-2 focus:ring-blue-600">
        </div>

        <!-- Account Type Filter -->
        <select name="type"
                class="bg-gray-700 text-white px-3 py-2 rounded min-w-[150px]">
            <option value="">All Types</option>
            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($type->id); ?>" <?php echo e(request('type') == $type->id ? 'selected' : ''); ?>>
                    <?php echo e($type->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <!-- Status Filter -->
        <select name="status"
                class="bg-gray-700 text-white px-3 py-2 rounded min-w-[150px]">
            <option value="">All Status</option>
            <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
            <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
        </select>

        <!-- Apply -->
        <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Apply
        </button>
    </form>

    <!-- Accounts Table -->
    <div class="bg-gray-800 text-gray-200 rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-blue-700 text-white uppercase text-sm">
                <tr>
                    <th class="px-4 py-3 text-left">Account No</th>
                    <th class="px-4 py-3 text-left">Member</th>
                    <th class="px-4 py-3 text-left">Type</th>
                    <th class="px-4 py-3 text-left">Balance</th>
                    <th class="px-4 py-3 text-left">Status</th>
                    <th class="px-4 py-3 text-left">Actions</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b border-gray-700">

                    <td class="px-4 py-3 font-semibold">
                       <a href="<?php echo e(route('admin.accounts.show', $account->id)); ?>"
       class="text-blue-400 hover:text-blue-600 font-semibold">
        <?php echo e($account->account_number); ?>

    </a>
                    </td>

                    <td class="px-4 py-3">
                        <?php echo e($account->user->name); ?>

                        <div class="text-gray-400 text-sm"><?php echo e($account->user->email); ?></div>
                    </td>

                    <td class="px-4 py-3">
                        <?php echo e($account->type->name); ?>

                    </td>

                    <td class="px-4 py-3">
                        UGX <?php echo e(number_format($account->balance)); ?>

                    </td>

                    <td class="px-4 py-3">
                        <?php if($account->status == 'active'): ?>
                            <span class="text-green-400 font-semibold">Active</span>
                        <?php else: ?>
                            <span class="text-red-400 font-semibold">Inactive</span>
                        <?php endif; ?>
                    </td>

                    <td class="px-4 py-3 space-x-3">

                        <a href="<?php echo e(route('admin.accounts.edit', $account->id)); ?>"
                           class="text-blue-400 hover:text-blue-600">Edit</a>

                        <form action="<?php echo e(route('admin.accounts.toggle_status', $account->id)); ?>"
                              method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button class="text-yellow-400 hover:text-yellow-600">
                                <?php echo e($account->status == 'active' ? 'Deactivate' : 'Activate'); ?>

                            </button>
                        </form>

                        <form action="<?php echo e(route('admin.accounts.destroy', $account->id)); ?>"
                              method="POST" class="inline"
                              onsubmit="return confirm('Delete this account?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="text-red-400 hover:text-red-600">Delete</button>
                        </form>

                    </td>

                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                <tr>
                    <td colspan="6" class="px-4 py-6 text-center text-gray-400">
                        No accounts found.
                    </td>
                </tr>

                <?php endif; ?>

            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        <?php echo e($accounts->links('pagination::tailwind')); ?>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/admin/accounts/index.blade.php ENDPATH**/ ?>