

<?php $__env->startSection('content'); ?>

<div class="p-6">

    <h1 class="text-3xl font-bold text-white mb-6">My Loans</h1>

    <?php if($loans->isEmpty()): ?>
        <!-- Empty State -->
        <div class="bg-gray-800 p-10 rounded-xl text-center shadow-lg border border-gray-700">
            <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" class="mx-auto w-32 opacity-70 mb-4">
            <h2 class="text-xl font-semibold text-gray-300">No Loans Found</h2>
            <p class="text-gray-400 mt-2">You haven’t applied for any loan yet.</p>

            <a href="<?php echo e(route('member.loans.apply')); ?>"
               class="mt-4 inline-block px-5 py-2 bg-blue-600 rounded-lg text-white hover:bg-blue-700 transition">
                Apply for a Loan
            </a>
        </div>

    <?php else: ?>

        <!-- Loan List Table -->
        <div class="bg-gray-800 p-6 rounded-xl shadow-lg border border-gray-700">
            <table class="w-full text-left text-gray-200">
                <thead class="bg-gray-700 text-gray-300 uppercase text-sm">
                    <tr>
                        <th class="p-3">Loan Type</th>
                        <th class="p-3">Amount</th>
                        <th class="p-3">Status</th>
                        <th class="p-3">Applied On</th>
                        <th class="p-3 text-right">Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b border-gray-700 hover:bg-gray-750 transition">
                            
                            <!-- Loan Type -->
                            <td class="p-3 flex items-center gap-2">
                                <div class="bg-blue-600 w-8 h-8 flex items-center justify-center rounded-full text-white">
                                    <span class="text-lg">💰</span>
                                </div>
                                <?php echo e($loan->loanType->name ?? 'N/A'); ?>

                            </td>

                            <!-- Amount -->
                            <td class="p-3 font-semibold text-green-400">
                                UGX <?php echo e(number_format($loan->principal)); ?>

                            </td>

                            <!-- Status with colored badges -->
                            <td class="p-3">
                                <?php
                                    $colors = [
                                        'pending' => 'bg-yellow-500',
                                        'approved' => 'bg-blue-500',
                                        'active' => 'bg-indigo-500',
                                        'rejected' => 'bg-red-600',
                                        'closed' => 'bg-green-600',
                                        'disbursed' => 'bg-purple-600',
                                    ];
                                ?>

                                <span class="px-3 py-1 rounded-full text-sm font-semibold text-white
                                    <?php echo e($colors[$loan->status] ?? 'bg-gray-600'); ?>">
                                    <?php echo e(ucfirst($loan->status)); ?>

                                </span>
                            </td>

                            <!-- Created Date -->
                            <td class="p-3 text-gray-300">
                                <?php echo e($loan->created_at->format('d M Y')); ?>

                            </td>

                            <!-- Actions -->
                            <td class="p-3 text-right">
                                <a href="<?php echo e(route('member.loans.show', $loan->id)); ?>"
                                   class="px-4 py-1 rounded bg-blue-600 hover:bg-blue-700 text-white text-sm transition">
                                    View
                                </a>
                            </td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\myproject\resources\views/member/loans/index.blade.php ENDPATH**/ ?>